% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotAvProbSensitivity.R
\name{plotAvProbSensitivity}
\alias{plotAvProbSensitivity}
\title{Plot distribution of avalanche problem distribution parameter.}
\usage{
plotAvProbSensitivity(AvProblems, Title, Percent = F)
}
\arguments{
\item{AvProblems}{DF with set of avalanche problems}

\item{Title}{Title of plot.}

\item{Percent}{Switch whether distribution should be shows as percent or counts. Default value is F.}
}
\description{
Plot distribution of avalanche problem sensitivity parameter.
}
\examples{
require(SarpBulletinToolsPrivate)
require(SarpBulletinTools)

## Retrieving data
Bulletins_Gl2012 <- getBulletins(Agency="PkCan", Seasons=2012, Regions="Glacier")
AvProblems <- Bulletins_Gl2012$AvProblems$Alp[Bulletins_Gl2012$AvProblems$Alp$CHARACTER=="Persistent Slabs",]

## Plot distribution of sensitivity parameter
plotAvProbSensitivity(AvProblems, Title="Persistent Slabs", Percent=T)

}
