% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotCTreeModelSingleProbOnHzdChart.R
\name{plotCTreeModelSingleProbOnHzdChart}
\alias{plotCTreeModelSingleProbOnHzdChart}
\title{Plots assessments and CTree predictions on hazard chart}
\usage{
plotCTreeModelSingleProbOnHzdChart(CTreeModel, ScenGen = list(),
  PlotType = "Predictions", ProbPlotDR = "Moderate",
  OnlyWhereObs = TRUE, WithNodeNum = TRUE, WithProb = TRUE,
  RuleLwd = 3, DRClrProdSum = FALSE, DRClr = getHzdColor(c(1, 2, 3,
  4)), DRClrTrans = 50, main = "")
}
\arguments{
\item{CTreeModel}{CTreeModel object created with createDRCTreeAndValidate().}

\item{ScenGen}{List with parameters for scenario (e.g., list(AGENCY="AvCan", AVPROB="PERS")). Default is empty list.}

\item{PlotType}{Specifies which plot is shown. Options are 'Predictions' (default), 'Observations' or 'Probabilities'.}

\item{ProbPlotDR}{Danger rating for probability plot. Values can only be low, moderate (default), considerable or high.}

\item{OnlyWhereObs}{Switch for whether tree rules should only be shown where observations are available (default) or across entire chart.}

\item{WithNodeNum}{Switch for whether node numbers are shown in prediction chart. Default is TRUE.}

\item{WithProb}{Switch for whether probability pie charts are shown in prediction chart. Default is TRUE.}

\item{RuleLwd}{Width of lines between rules. Default is 3}

\item{DRClrProdSum}{Switch for specifying what danger rating is shown in the background: product sum of proportions (TRUE, default) or largest proportion (FALSE)}

\item{DRClr}{Array for danger rating colors. Default are standard colors as defined in SarpGeneralVis package}

\item{main}{Title for chart that overwrites default}

\item{DRClrTransp}{Transparency for background danger rating colors in prediction chart. Must be between 10 and 99. Default is 50.}
}
\description{
Plots assessments and CTree predictions on hazard chart.
This function was created for Taylor Clarke's research in 2018.
}
\examples{
require(SarpBulletinTools)

## Get data
load(url("http://data.avalancheresearch.ca/2018_Analysis_Taylor.RData"))
nrow(TblAnalysis)

## Extract single problems and stack
SingleProbStacked <- extractAndStackSingleAvProblems(TblAnalysis)
table(SingleProbStacked$PROB_COMBINATION)

## Extract columns of interest and rename
TblTree <- SingleProbStacked[,c("AGENCY", "REGION", "MTNRANGE", "DAY0", "PROB_COMBINATION", "LIKELIHOOD_TYP", "SIZE_TYP")]
names(TblTree)
names(TblTree) <- c("AGENCY", "REGION", "MTNRANGE", "DAY0", "AVPROB", "LH", "SZ")

## Tree 1: Just LH and SZ for all av problems
## ******************************************
## Create tree model
TreeFormula <- "DAY0 ~ LH + SZ"
TreeModel1 <- createDRCTreeAndValidate(TreeFormula, TblTree)

## Plot tree
plot(TreeModel1$CTree)

## Plot observations and predictions on hzd chart
plotCTreeModelSingleProbOnHzdChart(TreeModel1, PlotType = "Obs")
plotCTreeModelSingleProbOnHzdChart(TreeModel1)

## Tree 2: LH and SZ for all av problems with agency
## *************************************************
## Create tree model
TreeFormula <- "DAY0 ~ LH + SZ + AGENCY"
TreeModel2 <- createDRCTreeAndValidate(TreeFormula, TblTree)

## Plot tree
plot(TreeModel2$CTree)

## Plot observations and predictions on hzd chart for different scenarios: AvCan or PkCan
par(mfrow=c(2,2))
plotCTreeModelSingleProbOnHzdChart(TreeModel2, ScenGen = list(AGENCY="AvCan"), PlotType = "Obs")
plotCTreeModelSingleProbOnHzdChart(TreeModel2, ScenGen = list(AGENCY="PkCan"), PlotType = "Obs")

plotCTreeModelSingleProbOnHzdChart(TreeModel2, ScenGen = list(AGENCY="AvCan"))
plotCTreeModelSingleProbOnHzdChart(TreeModel2, ScenGen = list(AGENCY="PkCan"))
par(mfrow=c(1,1))

## Compare with prediction for combined model
plotCTreeModelSingleProbOnHzdChart(TreeModel1)

## Tree 3: Add avalanche problem
## *****************************
## Create tree model
TreeFormula <- "DAY0 ~ LH + SZ + AGENCY + AVPROB"
TreeModel3 <- createDRCTreeAndValidate(TreeFormula, TblTree)

## Plot tree
plot(TreeModel3$CTree)

## Compare assessments of PRES, STORM and LDRY of AvCan and PkCan
par(mfrow=c(2,3))
plotCTreeModelSingleProbOnHzdChart(TreeModel3, ScenGen = list(AGENCY="AvCan", AVPROB="PERS"))
plotCTreeModelSingleProbOnHzdChart(TreeModel3, ScenGen = list(AGENCY="AvCan", AVPROB="STORM"))
plotCTreeModelSingleProbOnHzdChart(TreeModel3, ScenGen = list(AGENCY="AvCan", AVPROB="LDRY"))
plotCTreeModelSingleProbOnHzdChart(TreeModel3, ScenGen = list(AGENCY="PkCan", AVPROB="PERS"))
plotCTreeModelSingleProbOnHzdChart(TreeModel3, ScenGen = list(AGENCY="PkCan", AVPROB="STORM"))
plotCTreeModelSingleProbOnHzdChart(TreeModel3, ScenGen = list(AGENCY="PkCan", AVPROB="LDRY"))
par(mfrow=c(1,1))

}
