% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotCTreeModelTwoProbOnHzdChart.R
\name{plotCTreeModelTwoProbOnHzdChart}
\alias{plotCTreeModelTwoProbOnHzdChart}
\title{Plots assessments and CTree predictions on hazard chart for trees that include two problems.}
\usage{
plotCTreeModelTwoProbOnHzdChart(CTreeModel, Prob,
  ScenProb2 = list(list(LH = "P", SZ = "2.0")), ScenGen = list(),
  PlotType = "Predictions", OnlyWhereObs = TRUE, WithNodeNum = TRUE,
  WithProb = TRUE, RuleLwd = 3, DRClrProdSum = TRUE,
  DRClr = getHzdColor(c(1, 2, 3, 4)), DRClrTransp = 50, main = "")
}
\arguments{
\item{CTreeModel}{CTreeModel object created with createDRCTreeAndValidate().}

\item{Prob}{Array with problem abbreviations. The hazard chart is plotted for the first problem at the scenarios that are specificed for the second problem in parameter ScenProb2.}

\item{ScenProb2}{List of lists with scenarios for problem 2. Default is list(list(LH="P", SZ="2.0")).}

\item{ScenGen}{List with parameters for scenario (e.g., list(AGENCY="AvCan", AVPROB="PERS")). Default is empty list.}

\item{PlotType}{Specifies which plot is shown. Options are 'Predictions' (default) and 'Observations'.}

\item{OnlyWhereObs}{Switch for whether tree rules should only be shown where observations are available (default) or across entire chart.}

\item{WithNodeNum}{Switch for whether node numbers are shown in prediction chart. Default is TRUE.}

\item{WithProb}{Switch for whether probability pie charts are shown in prediction chart. Default is TRUE.}

\item{RuleLwd}{Width of lines between rules. Default is 3}

\item{DRClrProdSum}{Switch for specifying what danger rating is shown in the background: product sum of proportions (TRUE, default) or largest proportion (FALSE)}

\item{DRClr}{Array for danger rating colors. Default are standard colors as defined in SarpGeneralVis package}

\item{DRClrTransp}{Transparency for background danger rating colors in prediction chart. Must be between 10 and 99. Default is 50.}

\item{main}{Title for chart that overwrites default}
}
\description{
Plots assessments and CTree predictions on hazard chart for trees that include two problems.
This function was created for Taylor Clarke's research in 2018.
}
\examples{
require(SarpBulletinTools)

## Get data
load(url("http://data.avalancheresearch.ca/2018_Analysis_Taylor.RData"))
nrow(TblAnalysis)

## Extract storm slab and persistent slab
table(TblAnalysis$PROB_COMBINATION)
Tbl <- TblAnalysis[TblAnalysis$PROB_COMBINATION=="PERS_STORM",c("AGENCY", "REGION", "MTNRANGE", "DAY0", "PROB_COMBINATION", "PERS_LIKELIHOOD_TYP", "PERS_SIZE_TYP", "STORM_LIKELIHOOD_TYP", "STORM_SIZE_TYP")]
names(Tbl) <- c("AGENCY", "REGION", "MTNRANGE", "DAY0", "PROB_COMBINATION", "PERS_LH", "PERS_SZ", "STORM_LH", "STORM_SZ")

## Create tree
TreeFormula <- "DAY0 ~ PERS_LH + PERS_SZ + STORM_LH + STORM_SZ"
CTreeModel <- createDRCTreeAndValidate(TreeFormula, Tbl)

## Plot tree
plot(CTreeModel$CTree)

## Plot observations
plotCTreeModelTwoProbOnHzdChart(CTreeModel = CTreeModel, Prob = c("PERS", "STORM"), PlotType = "Observations")

## Plot PERS @ STORM default scenario (LH=P and SZ=2.0)
plotCTreeModelTwoProbOnHzdChart(CTreeModel = CTreeModel, Prob = c("PERS", "STORM"))

## Plot STORM @ PERS default scenario (LH=P and SZ=2.0)
plotCTreeModelTwoProbOnHzdChart(CTreeModel = CTreeModel, Prob = c("STORM", "PERS"))

## Plot STORM @ PERS with a range of likelihoods
ScenProb2 <- list(list(LH="UL", SZ="1.5"), list(LH="P", SZ="1.5"), list(LH="L", SZ="1.5"), list(LH="VL", SZ="1.5"))
plotCTreeModelTwoProbOnHzdChart(CTreeModel = CTreeModel, Prob = c("STORM", "PERS"), ScenProb2 = ScenProb2)

## Plot STORM @ PERS with a range of sizes
ScenProb2 <- list(list(LH="P", SZ="1.0"), list(LH="P", SZ="2.0"), list(LH="P", SZ="3.0"), list(LH="P", SZ="4.0"))
plotCTreeModelTwoProbOnHzdChart(CTreeModel = CTreeModel, Prob = c("STORM", "PERS"), ScenProb2 = ScenProb2)

}
