% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotDngProb_TS.R
\name{plotDngProb_TS}
\alias{plotDngProb_TS}
\title{Creates season plot for a group of forecast regions}
\usage{
plotDngProb_TS(bulletins, StartDate, EndDate)
}
\arguments{
\item{bulletins}{getBulletins() object}

\item{StartDate}{Start date in dates() format i.e. dates("2015-11-01", format="y-m-d").}

\item{EnDate}{End date in dates() format i.e. dates("2016-05-01", format="y-m-d").}
}
\description{
Creates season plot of avalanche bulletins
}
\examples{

require(SarpBulletinTools)
require(SarpBulletinToolsPrivate)
require(SarpGeneral)
if (!require(tidyr)) {install.packages("tidyr"); require(tidyr)}             ## package for data wrangling
if (!require(DescTools)) {install.packages("DescTools"); require(DescTools)} ## package for data wrangling


## Inputs
Regions    <- "Jasper"
season     <- 2017
bulletins <- getBulletins(Agency = "PkCan",
                          Regions = Regions,
                          Seasons = season)

StartDate  <- dates(paste0(season-1,"-11-01"), format="y-m-d")
EndDate    <- dates(paste0(season,"-05-01"), format="y-m-d")

## PLOT
OutputFilename <- paste0("C:/Users/bshan/sfuvault/Documents/ParksCanada/",season,"_", Regions,".png")

png(filename = OutputFilename, width=16.18, height=10, units="cm", pointsize=8, bg="white", res=600)

plotDngProb_TS(bulletins = bulletins,
               StartDate = StartDate,
               EndDate = EndDate)
#END PNG
dev.off()

}
