% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotDngProb_TS_COMP.R
\name{plotDngProb_TS_COMP}
\alias{plotDngProb_TS_COMP}
\title{Creates season plot to compare forecast regions}
\usage{
plotDngProb_TS_COMP(bulletins1, bulletins2, bulletins3, AvalancheProblem,
  StartDate, EndDate)
}
\arguments{
\item{StartDate}{Start date in dates() format i.e. dates("2015-11-01", format="y-m-d").}

\item{bulletins}{getBulletins() object}

\item{EnDate}{End date in dates() format i.e. dates("2016-05-01", format="y-m-d").}
}
\description{
Creates season plot to compare forecast regions
}
\examples{

require(SarpBulletinTools)
require(SarpBulletinToolsPrivate)
require(SarpGeneral)
if (!require(tidyr)) {install.packages("tidyr"); require(tidyr)}             ## package for data wrangling
if (!require(DescTools)) {install.packages("DescTools"); require(DescTools)} ## package for data wrangling


## Inputs
avp.levels  <- c("Deep Persistent Slabs","Persistent Slabs","Storm Slabs","Wind Slabs","Cornices","Wet Slabs","Loose Wet","Loose Dry")
AvalancheProblem <- avp.levels[4]
Regions1    <- "Jasper"
Regions2    <- "Banff, Yoho and Kootenay"
Regions3    <- "Kananaskis Country"
season     <- 2017

bulletins1 <- getBulletins(Agency = "PkCan",
                          Regions = Regions1,
                          Seasons = season)

bulletins2 <- getBulletins(Agency = "PkCan",
                           Regions = Regions2,
                           Seasons = season)

bulletins3 <- getBulletins(Agency = "AvCan",
                           Regions = Regions3,
                           Seasons = season)

StartDate  <- dates(paste0(season-1,"-11-01"), format="y-m-d")
EndDate    <- dates(paste0(season,"-05-01"), format="y-m-d")

## PLOT
OutputFilename <- paste0("C:/Users/bshan/sfuvault/Documents/ParksCanada/", AvalancheProblem, ".png")

png(filename = OutputFilename, width=16.18, height=5.5, units="cm", pointsize=8, bg="white", res=600)

plotDngProb_TS_COMP(bulletins1 = bulletins1,
                    bulletins2 = bulletins2,
                    bulletins3 = bulletins3,
                    AvalancheProblem = AvalancheProblem,
                    StartDate = StartDate,
                    EndDate = EndDate)
#END PNG
dev.off()

}
