% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotHzdChart.R
\name{plotHzdChart}
\alias{plotHzdChart}
\title{Plot hazard chart from avalanche problem component of hazard assessment object.}
\usage{
plotHzdChart(AvProblems, AvProblemsFaded = NULL,
  Title = "Hazard Chart", WithPoints = T, Transparency = "50",
  Shape = "square", NumPoints = 50, MedianShape = F,
  SuppressWarnings = T, cex.AdditionalText = 0.66, sumProb = T,
  ylab = "Likelihood of Avalanche(s)", xlab = "Destructive Size",
  cex.lab = 0.5, cex.lab.a = 1)
}
\arguments{
\item{AvProblems}{DF with avalanche problems}

\item{Title}{Title of chart. Default value is 'Hazard Chart'.}

\item{WithPoints}{Switch whether chart should be plotted with points. Default is TRUE.}

\item{Transparency}{The transparency of the blob background. Value can be between 00 and 99. Default value is 50.}

\item{Shape}{For specifying the shape of the blob. Values can be 'ellipse' or 'square' (default).}

\item{NumPoints}{Number of point per quater section of ellipse. Default value is 50.}

\item{MedianShape}{Switch for showing only median ellipse only. Default value is F.}

\item{SuppressWarnings}{Switch for suppressing warning message about application of is.na to S4 object. Default is TRUE.}
}
\description{
Plot hazard chart from avalanche problem component of hazard assessment object.
}
\examples{
require(SarpBulletinToolsPrivate)
require(SarpBulletinTools)

Operation <- "AvCan"
Season <- 2015
Region <- "Sea-to-Sky"

## Entire Season - alpine elevation band
BulletinsSeason <- getBulletins(Agency=Operation, Seasons=Season, Regions=Region)
AvProblemsAlp <- BulletinsSeason$AvProblems$Alp

plotHzdChart(AvProblems = AvProblemsAlp[AvProblemsAlp$CHARACTER=="Wind Slabs",], Title="Wind Slabs")
plotHzdChart(AvProblemsAlp[AvProblemsAlp$CHARACTER=="Deep Persistent Slabs",], Title="Deep Persistent Slabs")
plotHzdChart(AvProblemsAlp[AvProblemsAlp$CHARACTER=="Persistent Slabs",], Title="Persistent Slabs")

## Median chart
plotHzdChart(AvProblemsAlp[AvProblemsAlp$CHARACTER=="Wind Slabs",], Title="Wind Slabs - Median", MedianShape=T)
plotHzdChart(AvProblemsAlp, Title="All Avalanche Problems - Median", MedianShape=T)

## Single day
Date <- dates("2015-02-05", format="y-m-d")
BulletinSingleDay <- getBulletins(Agency=Operation, StartDate=Date, Regions=Region)
summary(BulletinSingleDay)

plotHzdChart(BulletinSingleDay$AvProblems$Alp, Title=paste0(Region, " - ALP - ", Date))
plotHzdChart(BulletinSingleDay$AvProblems$Tl, Title=paste0(Region, " - TL - ", Date))
plotHzdChart(BulletinSingleDay$AvProblems$Btl, Title=paste0(Region, " - BTL - ", Date))

}
