% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotHzdChartCount.R
\name{plotHzdChartCount}
\alias{plotHzdChartCount}
\title{Plot raster in hazard chart with counts or percentages of avalanche problems.}
\usage{
plotHzdChartCount(AvProblems, Title = "Hazard Chart", WithContours = T,
  Percent = F, PercentInterval = 5, Shape = "square",
  cex.AdditionalText = 0.66, NumPoints = 50, IDCol = "PROBLEM_ID",
  SuppressWarnings = T)
}
\arguments{
\item{AvProblems}{DF with avalanche problems}

\item{Title}{Title of chart. Default value is 'Hazard Chart'.}

\item{WithContours}{Switch whether chart should be plotted with contour lines. Default is TRUE.}

\item{Percent}{Switch whether plotted values should be percentages instead of counts. Default is F.}

\item{PercentInterval}{If percentage values are plotted with contour lines, this parameter specifies the contour intervals.}

\item{Shape}{For specifying the shape of the blob. Values can be 'ellipse' or 'square' (default).}

\item{cex.AdditionalText}{Scalling factor for additional text. Default value is 0.66.}

\item{NumPoints}{Number of point per quater section of ellipse. Default value is 50.}

\item{SuppressWarnings}{Switch for suppressing warning message about application of is.na to S4 object. Default is TRUE.}
}
\description{
Plot raster in hazard chart with counts or percentages of avalanche problems.
}
\examples{
require(SarpBulletinToolsPrivate)
require(SarpBulletinTools)

Bulletins_BYK <- getBulletins(Agency="PkCan", Seasons=2015, Regions="Banff, Yoho and Kootenay")
AlpAvProb_BYK <- Bulletins_BYK$AvProblems$Alp

Bulletins_NCol <- getBulletins(Agency="AvCan", Seasons=2015, Regions="North Columbia - Monashees & Selkirks")
AlpAvProb_NCol <- Bulletins_NCol$AvProblems$Alp

par(mfrow=c(2,2))

plotHzdChart(AlpAvProb_BYK[AlpAvProb_BYK$CHARACTER=="Wind Slabs",], Shape = "Square", Title="2015 B/Y/K: Alp Wind Slabs", cex.AdditionalText=0.5)
plotHzdChart(AlpAvProb_BYK[AlpAvProb_BYK$CHARACTER=="Deep Persistent Slabs",], Shape = "Square", Title="2015 B/Y/K: Alp Deep Pers Slabs", cex.AdditionalText=0.5)
plotHzdChart(AlpAvProb_NCol[AlpAvProb_NCol$CHARACTER=="Wind Slabs",], Shape = "Square", Title="2015 NCol: Alp Wind Slabs", cex.AdditionalText=0.5)
plotHzdChart(AlpAvProb_NCol[AlpAvProb_NCol$CHARACTER=="Deep Persistent Slabs",], Shape = "Square", Title="2015 NCol: Alp Deep Pers Slabs", cex.AdditionalText=0.5)

plotHzdChartCount(AlpAvProb_BYK[AlpAvProb_BYK$CHARACTER=="Wind Slabs",], Shape = "Square", Percent = T, PercentInterval=10, Title="2015 B/Y/K: Alp Wind Slabs", cex.AdditionalText=0.5)
plotHzdChartCount(AlpAvProb_BYK[AlpAvProb_BYK$CHARACTER=="Deep Persistent Slabs",], Shape = "Square", Percent = T, PercentInterval=10, Title="2015 B/Y/K: Alp Deep Pers Slabs", cex.AdditionalText=0.5)
plotHzdChartCount(AlpAvProb_NCol[AlpAvProb_NCol$CHARACTER=="Wind Slabs",], Shape = "Square", Percent = T, PercentInterval=10, Title="2015 NCol: Alp Wind Slabs", cex.AdditionalText=0.5)
plotHzdChartCount(AlpAvProb_NCol[AlpAvProb_NCol$CHARACTER=="Deep Persistent Slabs",], Shape = "Square", Percent = T, PercentInterval=10, Title="2015 NCol: Alp Deep Pers Slabs", cex.AdditionalText=0.5)

par(mfrow=c(1,1))

}
