% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotMapHzdRating.R
\name{plotMapHzdRating}
\alias{plotMapHzdRating}
\title{Plot bulletin region map with hazard ratings}
\usage{
plotMapHzdRating(Date, Agency, RegionNames = "All")
}
\arguments{
\item{Date}{Date of day.}

\item{Agency}{Instead of RegionsNames, it is possible to provide the Agency name. Either AvCan or PkCan.}

\item{RegionNames}{Single or array of bulletin region names. Default is 'All'}
}
\description{
Plot bulletin region map with hazard ratings
}
\examples{
require(SarpBulletinTools)
require(SarpBulletinToolsPrivate)

Agency <- "AvCan"
RegionNames <- c("South Rockies", "South Columbias", "Kootenay Boundary", "Lizard Range")
Date <- dates("2015-02-05", format="y-m-d")

plotMapHzdRating(Date, Agency, RegionNames)
}
