% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepareWxDataInfoEX.R
\name{prepareWxDataInfoEX}
\alias{prepareWxDataInfoEX}
\title{Prepares infoEX data for Mock and Birkeland 2000 classification}
\usage{
prepareWxDataInfoEX(wxObs)
}
\arguments{
\item{wxObs}{Output from getDailyWxObsFromWxDB()}
}
\value{
Dataframe with result
}
\description{
Prepares infoEX data for Mock and Birkeland 2000 classification
}
\examples{
## DEPENDENCIES
## ************


require(SarpGeneral)
require(SarpBulletinTools)
require(SarpBulletinToolsPrivate)


## CALL DATA
## *********


wx_db <- getDailyWxObsFromWxDBOverview()

wxObs <- getDailyWxObsFromWxDB(Source = 'InfoEx',
                               OperName = wx_db$InfoEx$oper_name[1],
                               WxSiteName = wx_db$InfoEx$wxsite_name[1])
## PREP DATA
## *********


wx.data <- prepareWxDataInfoEX(wxObs)


## Mock and Birkeland classification
## *********************************


deriveSnowClimateClass_MockBirkeland2000(wx.data)

}
