% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sendQueryToBulletinRegionsDB.R
\name{sendQueryToBulletinRegionDB}
\alias{sendQueryToBulletinRegionDB}
\title{Send SQL query to PostgreSQL/PostGIS bulletin regions database.}
\usage{
sendQueryToBulletinRegionDB(Query, Verbose = F,
  SuppressPostgreSQLWarnings = T, MaxNumTries = 10)
}
\arguments{
\item{Query}{SQL query.}

\item{Verbose}{Switch for printing SQL query. Default value is FALSE.}

\item{SuppressPostgreSQLWarnings}{Switch for turning warnings off. Default value is TRUE.}

\item{MaxNumTries}{Number of maximum tries that are attempted. Default value is 10.}

\item{Operation}{Name of operation for accessing correct database.}

\item{DBType}{Type of database to send the query to. Can be 'Main' (default) or 'NodeJS' for database that feeds online viewer}
}
\description{
Send SQL query that does not produce any result (e.g., delete query, insert query, ...) to PostgreSQL/PostGIS bulletin regions database. IMPORTANT: Only use for single queries or short loops. Long loops are much faster if the DB connection is established once and all records are submitted together.
}
