% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/standardizeBulletinRegionNames.R
\name{standardizeBulletinRegionNames}
\alias{standardizeBulletinRegionNames}
\title{Standarize bulletin region names.}
\usage{
standardizeBulletinRegionNames(BulletinRegionNameArray,
  ToWhichName = "First", AsFactor = T)
}
\arguments{
\item{ToWhichName}{Switch for specify which names from the list in BulletinRegionNamesEquivalency should be used. Can be 'First' (default) or 'Last'.}

\item{AsFactor}{Switch that determines whether output array is turned into a factor. Default value is TRUE.}

\item{BulletinRegionNameArrays}{List of bulletin region names}
}
\value{
Standarized list of bulletin region names
}
\description{
Standarize bulletin region names
}
\examples{
require(SarpBulletinTools)
require(SarpBulletinToolsPrivate)

## With using the first names (default)
Region <- "South Coast - Inland"
(Test <- addEquivalentBulletinRegionNames(Region))
standardizeBulletinRegionNames(Test)

## With using the last names
Region <- "South Coast - Inland"
(Test <- addEquivalentBulletinRegionNames(Region))
standardizeBulletinRegionNames(Test, ToWhichName = "Last")

## Without turning it into a factor
Region <- "South Coast - Inland"
(Test <- addEquivalentBulletinRegionNames(Region))
standardizeBulletinRegionNames(Test, AsFactor = F)

}
