% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarizeAvProbAspect.R
\name{summarizeAvProbAspect}
\alias{summarizeAvProbAspect}
\title{Summarize and plot aspect distributions of avalanche problems.}
\usage{
summarizeAvProbAspect(AvProblems, GroupByCharacter = T, ShowPlots = T,
  Title = "Aspect Summary", WithJitter = F)
}
\arguments{
\item{AvProblems}{DF with avalanche problems}

\item{GroupByCharacter}{Switch for whether to summarize aspect information by avalanche problem type. Default value is T.}

\item{ShowPlots}{Switch for whether aspect summary should be plotted. Default value is T.}

\item{Title}{Title of chart. Default value is 'Hazard Chart'.}

\item{WithJitter}{Switch to add jitter to plot to ensure that all lines can be seen. Default value is F.}
}
\description{
Summarize and plot aspect distributions of avalanche problems.
}
\examples{

require(SarpBulletinToolsPrivate)
require(SarpBulletinTools)

Operation <- "AvCan"
Season <- 2015
Region <- "Sea-to-Sky"

## Entire Season - alpine elevation band
BulletinsSeason <- getBulletins(Agency=Operation, Seasons=Season, Regions=Region)
AvProblems <- BulletinsSeason$AvProblems$Alp

AspectSummary <- summarizeAvProbAspect(AvProblems, Title="Aspect Summary - Individual Av Problem Types")
AspectSummary <- summarizeAvProbAspect(AvProblems, Title="Aspect Summary - Individual Av Problem Types", WhithJitter=T)
AspectSummary <- summarizeAvProbAspect(AvProblems, GroupByCharacter=F, Title="Aspect Summary - All Av Problem Types")

}
