% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/testAvProbDistributionDiff.R
\name{testAvProbDistributionDiff}
\alias{testAvProbDistributionDiff}
\title{Test statistical differences in avalanche problem distribution parameter.}
\usage{
testAvProbDistributionDiff(AvProblems1, AvProblems2,
  AvProblems1Label = "AvProblems1", AvProblems2Label = "AvProblems2",
  SuppressWarnings = T, ShowPlots = T)
}
\arguments{
\item{AvProblems1}{DF with first set of avalanche problems}

\item{AvProblems2}{DF with second set of avalanche problems}

\item{AvProblems1Label}{Optional label for AvProblems1 in output dataframe. Default value is 'AvProblem1'.}

\item{AvProblems2Label}{Optional label for AvProblems2 in output dataframe. Default value is 'AvProblem2'.}

\item{SuppressWarnings}{Switch for suppressing warning message about application of is.na to S4 object. Default is TRUE.}

\item{ShowPlots}{Switch for showing plots. Default value is T.}
}
\description{
Test statistical differences in avalanche problem distribution parameter by applying the Wilcoxon rank-sum test.
}
\examples{
require(SarpBulletinToolsPrivate)
require(SarpBulletinTools)

## Retrieving data
Bulletins_Gl2012 <- getBulletins(Agency="PkCan", Seasons=2012, Regions="Glacier")
AvProblems1 <- Bulletins_Gl2012$AvProblems$Alp[Bulletins_Gl2012$AvProblems$Alp$CHARACTER=="Persistent Slabs",]
AvProblems2 <- Bulletins_Gl2012$AvProblems$Alp[Bulletins_Gl2012$AvProblems$Alp$CHARACTER=="Storm Slabs",]

## Testing differences in distribution parameter
Results <- testAvProbDistributionDiff(AvProblems1, AvProblems2, AvProblems1Label="Persistent Slabs", AvProblems2Label="Storm Slabs")

}
