% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/testAvProbEllipseDiff.R
\name{testAvProbEllipseDiff}
\alias{testAvProbEllipseDiff}
\title{Test statistical differences in avalanche problem ellipse parameters.}
\usage{
testAvProbEllipseDiff(AvProblems1, AvProblems2,
  AvProblems1Label = "AvProblems1", AvProblems2Label = "AvProblems2",
  SuppressWarnings = T, ShowPlots = T)
}
\arguments{
\item{AvProblems1}{DF with first set of avalanche problems}

\item{AvProblems2}{DF with second set of avalanche problems}

\item{AvProblems1Label}{Optional label for AvProblems1 in output dataframe. Default value is 'AvProblem1'.}

\item{AvProblems2Label}{Optional label for AvProblems2 in output dataframe. Default value is 'AvProblem2'.}

\item{SuppressWarnings}{Switch for suppressing warning message about application of is.na to S4 object. Default is TRUE.}

\item{ShowPlots}{Switch for showing plots. Default value is T.}
}
\description{
Test statistical differences in avalanche problem ellipse parameters by applying the Wilcoxon rank-sum test.
}
\examples{
require(SarpBulletinToolsPrivate)
require(SarpBulletinTools)

## Retrieving data
Bulletins_SC2012 <- getBulletins(Agency="AvCan", Seasons=2012, Regions="South Columbia")
AvProblems1 <- Bulletins_SC2012$AvProblems$Alp[Bulletins_SC2012$AvProblems$Alp$CHARACTER=="Persistent Slabs",]
AvProblems2 <- Bulletins_SC2012$AvProblems$Alp[Bulletins_SC2012$AvProblems$Alp$CHARACTER=="Storm Slabs",]

## Testing differences in ellipse parameters
Results <- testAvProbEllipseDiff(AvProblems1, AvProblems2, AvProblems1Label="Persistent Slabs", AvProblems2Label="Storm Slabs")

}
