% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/testAvProbEllipseDiffLoop.R
\name{testAvProbEllipseDiffLoop}
\alias{testAvProbEllipseDiffLoop}
\title{Performs testAvProbEllipseDiff() for all combinations of values in a specified column.}
\usage{
testAvProbEllipseDiffLoop(AvProblemsDF, ColName,
  ColValues = levels(AvProblemsDF[, ColName]), SuppressWarnings = T,
  ShowPlots = T)
}
\arguments{
\item{ColName}{Name of column in AvProblemDF that contains the values for the comparisons. Needs to be a factor.}

\item{ColValues}{Values for comparison. Default value is the levels of the ColName column.}

\item{SuppressWarnings}{Switch for suppressing warning message about application of is.na to S4 object. Default is TRUE.}

\item{ShowPlots}{Switch for showing plots. Default value is T.}

\item{AvProblemDF}{DF with avalanche problems}
}
\description{
Performs testAvProbEllipseDiff() for all combinations of values in a specified column.
}
\examples{
require(SarpBulletinToolsPrivate)
require(SarpBulletinTools)

## Retrieving data
StartDate <- dates("2015-10-01", format="y-m-d")
EndDate <- dates("2016-05-01", format="y-m-d")

Bulletins_SC <- getBulletins(Agency="AvCan", StartDate=StartDate, EndDate=EndDate, Regions="South Columbia")
summary(Bulletins_SC)

## Comparing all avalanche problem types in the alpine
Results_Alp_AllProblems <- testAvProbEllipseDiffLoop(Bulletins_SC$AvProblems$Alp, ColName="CHARACTER")

## Only comparing persistent and storm avalanche problem types in the alpine
Results_Alp_PersVsStorm <- testAvProbEllipseDiffLoop(Bulletins_SC$AvProblems$Alp, ColName="CHARACTER", ColValues=c("Persistent Slabs", "Storm Slabs"))

## Comparing persistent avalanche problems between different elevation bands
Pers_Alp <- Bulletins_SC$AvProblems$Alp[Bulletins_SC$AvProblems$Alp$CHARACTER=="Persistent Slabs",]
Pers_Alp$Elev <- "Alp"
Pers_Tl  <- Bulletins_SC$AvProblems$Tl[Bulletins_SC$AvProblems$Tl$CHARACTER=="Persistent Slabs",]
Pers_Tl$Elev <- "Tl"
Pers_Btl <- Bulletins_SC$AvProblems$Btl[Bulletins_SC$AvProblems$Btl$CHARACTER=="Persistent Slabs",]
Pers_Btl$Elev <- "Btl"

Pers_Elev <- rbind(Pers_Alp, Pers_Tl, Pers_Btl)
Pers_Elev$Elev <- factor(Pers_Elev$Elev)
rm(Pers_Alp, Pers_Tl, Pers_Btl)

Results_Pers_AllElev <- testAvProbEllipseDiffLoop(Pers_Elev, ColName="Elev")

}
