% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/testAvProbSensitivityDiffLoop.R
\name{testAvProbSensitivityDiffLoop}
\alias{testAvProbSensitivityDiffLoop}
\title{Performs testAvProbSensitivityDiff() for all combinations of values in a specified column.}
\usage{
testAvProbSensitivityDiffLoop(AvProblemsDF, ColName,
  ColValues = levels(AvProblemsDF[, ColName]), SuppressWarnings = T,
  ShowPlots = T)
}
\arguments{
\item{ColName}{Name of column in AvProblemDF that contains the values for the comparisons. Needs to be a factor.}

\item{ColValues}{Values for comparison. Default value is the levels of the ColName column.}

\item{SuppressWarnings}{Switch for suppressing warning message about application of is.na to S4 object. Default is TRUE.}

\item{ShowPlots}{Switch for showing plots. Default value is T.}

\item{AvProblemDF}{DF with avalanche problems}
}
\description{
Performs testAvProbSensitivityDiff() for all combinations of values in a specified column.
}
\examples{
require(SarpBulletinToolsPrivate)
require(SarpBulletinTools)

## Retrieving data
StartDate <- dates("2014-10-01", format="y-m-d")
EndDate <- dates("2016-05-01", format="y-m-d")

Bulletins_Gl <- getBulletins(Agency="PkCan", StartDate=StartDate, EndDate=EndDate, Regions="Glacier")
summary(Bulletins_Gl)

## Comparing all avalanche problem types in the alpine
Results_Alp_AllProblems <- testAvProbSensitivityDiffLoop(Bulletins_Gl$AvProblems$Alp, ColName="CHARACTER")

## Only comparing persistent and storm avalanche problem types in the alpine
Results_Alp_PersVsStorm <- testAvProbSensitivityDiffLoop(Bulletins_Gl$AvProblems$Alp, ColName="CHARACTER", ColValues=c("Persistent Slabs", "Storm Slabs"))

## Comparing persistent avalanche problems between different elevation bands
Pers_Alp <- Bulletins_Gl$AvProblems$Alp[Bulletins_Gl$AvProblems$Alp$CHARACTER=="Persistent Slabs",]
Pers_Alp$Elev <- "Alp"
Pers_Tl  <- Bulletins_Gl$AvProblems$Tl[Bulletins_Gl$AvProblems$Tl$CHARACTER=="Persistent Slabs",]
Pers_Tl$Elev <- "Tl"
Pers_Btl <- Bulletins_Gl$AvProblems$Btl[Bulletins_Gl$AvProblems$Btl$CHARACTER=="Persistent Slabs",]
Pers_Btl$Elev <- "Btl"

Pers_Elev <- rbind(Pers_Alp, Pers_Tl, Pers_Btl)
Pers_Elev$Elev <- factor(Pers_Elev$Elev)
rm(Pers_Alp, Pers_Tl, Pers_Btl)

Results_Pers_AllElev <- testAvProbSensitivityDiffLoop(Pers_Elev, ColName="Elev")

}
