% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/testHzdChartCountDiff.R
\name{testHzdChartCountDiff}
\alias{testHzdChartCountDiff}
\title{Test statistical differences between two summary hazard charts.}
\usage{
testHzdChartCountDiff(AvProblems1, AvProblems2,
  AvProblems1Label = "AvProblems1", AvProblems2Label = "AvProblems2",
  Shape = "square", NumPoints = 50, SuppressWarnings = T,
  ShowPlots = T)
}
\arguments{
\item{AvProblems1}{DF with first set of avalanche problems}

\item{AvProblems2}{DF with second set of avalanche problems}

\item{AvProblems1Label}{Optional label for AvProblems1 in output dataframe. Default value is 'AvProblem1'.}

\item{AvProblems2Label}{Optional label for AvProblems2 in output dataframe. Default value is 'AvProblem2'.}

\item{Shape}{For specifying the shape of the blob. Values can be 'ellipse' (default) or 'square'.}

\item{NumPoints}{Number of point per quater section of ellipse. Default value is 50.}

\item{SuppressWarnings}{Switch for suppressing warning message about application of is.na to S4 object. Default is TRUE.}

\item{ShowPlots}{Switch for showing plots. Default value is T.}
}
\description{
Test statistical differences between two summary hazard charts by applying the Wilcoxon rank-sum test and the Kolmogorov–Smirnov test in the x and y axis through the cell with the highest count overall.
}
\examples{
require(SarpBulletinToolsPrivate)
require(SarpBulletinTools)

## Retrieving data
Bulletins_SC2012 <- getBulletins(Agency="AvCan", Seasons=2012, Regions="South Columbia")
AlpAvProb_SC2012 <- Bulletins_SC2012$AvProblems$Alp
AlpAvProb_SC2012 <- AlpAvProb_SC2012[AlpAvProb_SC2012$CHARACTER=="Persistent Slabs",]

Bulletins_SC2014 <- getBulletins(Agency="AvCan", Seasons=2014, Regions="South Columbia")
AlpAvProb_SC2014 <- Bulletins_SC2014$AvProblems$Alp
AlpAvProb_SC2014 <- AlpAvProb_SC2014[AlpAvProb_SC2014$CHARACTER=="Persistent Slabs",]

## Percentage plots
par(mfrow=c(1,2))
plotHzdChartCount(AlpAvProb_SC2012, Shape = "Square", Percent = T, PercentInterval=10, Title="2012", cex.AdditionalText=0.5)
plotHzdChartCount(AlpAvProb_SC2014, Shape = "Square", Percent = T, PercentInterval=10, Title="2014", cex.AdditionalText=0.5)
par(mfrow=c(1,1))

## Testing differences
Results <- testHzdChartCountDiff(AlpAvProb_SC2012, AlpAvProb_SC2014,
                                 AvProblems1Label = "Alp_Pers_SC2012",
                                 AvProblems2Label = "Alp_Pers_SC2014",
                                 Shape = "Square",
                                 ShowPlots=T)

}
