% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/writeBulletinRegionGeomToDB.R
\name{writeBulletinRegionGeomToDB}
\alias{writeBulletinRegionGeomToDB}
\title{Write geometries of bulletin region to bulletin geodatabase.}
\usage{
writeBulletinRegionGeomToDB(SPDF, GeomCol = "geom", SRID = 4617,
  Overwrite = F, Polygon2Multipolygon = T, Verbose = F,
  SuppressPostgreSQLWarnings = T, ShowCounter = 1, ObjLabel = "row",
  MaxNumTries = 10)
}
\arguments{
\item{SPDF}{Spatial dataframe with bulletin geometries.}

\item{GeomCol}{Name of geometry column in database table}

\item{SRID}{Numeric reference to coordinate system for geospatial information}

\item{Overwrite}{Boolean flag for whether the entire table should be overwritten (i.e., all records deleted first)}

\item{Polygon2Multipolygon}{Boolean flag for indicating whether a polygon layer needs to be converted into a multipolygon layer}

\item{Verbose}{Switch for printing of query}

\item{SuppressPostgreSQLWarnings}{Switch for supressing warning messages from postgresqlExecStatement. Default value is TRUE. Turn on for debugging!}

\item{ShowCounter}{Numeric value that specifies whether counter for queries should be shown (>0) and at what interval}

\item{ObjLabel}{Label for making process counter more meaningful.}

\item{MaxNumTries}{Number of maximum tries that are attempted. Default value is 10.}
}
\description{
Write geometries of bulletin region to bulletin geodatabase.
}
