% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/writeDFToWxDB.R
\name{writeDFToWxDB}
\alias{writeDFToWxDB}
\title{Write dataframe to prexisting table in PostgreSQL/PostGIS Wx database}
\usage{
writeDFToWxDB(DF, Schema, DBTbl, Overwrite = F, Verbose = F,
  SuppressPostgreSQLWarnings = T, ShowCounter = 1, ObjLabel = "row",
  MaxNumTries = 10)
}
\arguments{
\item{DF}{Dataframe}

\item{Schema}{Name of database schema that contains database table}

\item{DBTbl}{Name of database table with geometry}

\item{Overwrite}{Boolean flag for whether the entire table should be overwritten (i.e., all recrods deleted first)}

\item{Verbose}{Switch for printing of query}

\item{SuppressPostgreSQLWarnings}{Switch for supressing warning messages from postgresqlExecStatement. Default value is TRUE. Turn on for debugging!}

\item{ShowCounter}{Numeric value that specifies whether counter for queries should be shown (>0) and at what interval}

\item{ObjLabel}{Label for making process counter more meaningful.}

\item{MaxNumTries}{Number of maximum tries that are attempted. Default value is 10.}
}
\description{
Writes entire content of spatial dataframe to prexisting table in PostgreSQL/PostGIS Wx database. All of the columns of the spatial dataframe need to exist in the database table.
}
