## ****************************************
## Adding data to package SarpBulletinTools
## ****************************************

## BestDBSource
## ************

BestDB_AvCan <- data.frame(Season=c(2010, 2011, 2012, 2013, 2014, 2015, 2016, 2017, 2018),
                           Agency="AvCan",
                           DB=c("HzdWebsite", "HzdWebsite", "Bulletin", "Bulletin", "Bulletin", "Bulletin", "Bulletin", "AvalX", "AvalX"))

BestDB_PkCan <- data.frame(Season=c(2012, 2013, 2014, 2015, 2016, 2017, 2018),
                           Agency="PkCan",
                           DB=c("AvalX", "AvalX", "AvalX", "AvalX", "AvalX", "AvalX", "AvalX"))

BestDBSource <- rbind(BestDB_AvCan, BestDB_PkCan)

devtools::use_data(BestDBSource, overwrite=T)


## ListAvProblemTypes
## ******************

ListAvProblemTypes <- c("Deep Persistent Slabs", "Persistent Slabs", "Storm Slabs", "Wind Slabs", "Cornices",
                        "Loose Dry", "Wet Slabs", "Loose Wet")

devtools::use_data(ListAvProblemTypes, overwrite=T)

ListAvProblemTypesAbbrev <- c("DPERS", "PERS", "STORM", "WIND", "CORN", "LDRY", "WET", "LWET")

devtools::use_data(ListAvProblemTypesAbbrev, overwrite=T)


## LevelsSensitivity
## *****************

LevelsSensitivity <- c("Unreactive", "Stubborn", "Touchy", "Very Touchy")
devtools::use_data(LevelsSensitivity, overwrite=T)


## LevelsDistribution
## *****************

LevelsDistribution <- c("Isolated", "Specific", "Widespread")
devtools::use_data(LevelsDistribution, overwrite=T)


## LevelsLikelihood
## ****************

LevelsLikelihood <- c("UL", "UL-P", "P", "P-L", "L", "L-VL", "VL", "VL-AC", "AC")
devtools::use_data(LevelsLikelihood, overwrite=T)


## LevelsSize
LevelsSize <- c("1.0", "1.5", "2.0", "2.5", "3.0", "3.5", "4.0", "4.5", "5.0")
devtools::use_data(LevelsSize, overwrite=T)


## BulletinNamesEquivalencies
## **************************
## Do not use this anymore
BulletinRegionNamesEquivalency <- list(c("South Coast Inland", "South Coast - Inland"),
                                       c("North Columbia", "North Columbia - Monashees & Selkirks"),
                                       c("Cariboos", "North Columbia - Cariboos"))
devtools::use_data(BulletinRegionNamesEquivalency, overwrite=T)
