require(raster)

DEM_Raw <- raster("C:/Temp/dem2/50n120w_20101117_gmted_mea150.tif")

require(SarpBulletinTools)
require(SarpBulletinToolsPrivate)

GNP <- getBulletinRegionGeomSPDF(Season = 2018, RegionNames = "Glacier")
GNP


## Specify extent for cropping dem
extent <- c(-118.1, -117, 50.9, 51.6)
DEM <- crop(DEM_Raw, extent)

## Plot dem to check
plot(DEM)
plot(GNP, add=T)

## Check terrain coloring
plot(GNP)
plotTerrain(DEM, add=T)
plot(GNP, add=T)

## Save file
save(DEM, file=paste0("C:/Temp/gmted_mea075_Bull_GPN.rda"), compress = TRUE)
writeRaster(DEM, file=paste0("C:/Temp/gmted_mea075_Bull_GPN.tif"))
