#' Connect to PostGIS/PostgreSQL GPS database
#'
#' Connect to PostGIS/PostgreSQL GPS database for specific operation
#' @param Operation Name of operation
#' @param ReadOnly Boolean flag for whether the database connection should be read only (default is TRUE).
#' @param DBType Type of database to create connection with. Value can be 'Main' (default), 'Old' (older version, not available for all operations) or 'NodeJS' (database that feeds online viewer).
#' @param ConnectToDefaultPostgresDB Switch for specifying whether connections should be to the default Postgres database (i.e., postgres)
#' @return Database connection of the class PostgresSQLConnection
#' @export

connectToGPSDB <- function(Operation, ReadOnly=T, DBType="Main", ConnectToDefaultPostgresDB=F) {

  DBType <- toupper(DBType)
  
  if (ConnectToDefaultPostgresDB) {
    DBName <- "postgres"
  } else {
    DBName <- getGPSDBName(Operation, DBType)
  }
  
  if (DBType=="MAIN" | DBType=="OLD") {
    
    # Host <- "sarp.rem.sfu.ca"
    Host <- "142.58.21.196"

    if(ReadOnly) {
      User <- "pascal"
      Pwd <- "success2288"
      ## Currently no account for read only
    } else {
      User <- "pascal"
      Pwd <- "success2288"
    }
  
  } else if (DBType=="NODEJS") {
    
    Host <- "avalanche.rem.sfu.ca"
    
    if(ReadOnly) {
      User <- "pascal"
      Pwd <- "success2288"
      ## Currently no account for read only
    } else {
      User <- "pascal"
      Pwd <- "success2288"
    }
    
  } else {
    
    stop("Invalid value for DBType!")
    
  }
  
  DBCon <- RPostgreSQL::dbConnect(dbDriver("PostgreSQL"), host=Host, user=User, password=Pwd, dbname=DBName)
    
  return(DBCon)
}
