#' Get name of PostGIS/PostgreSQL GPS database
#'
#' Get name of PostGIS/PostgreSQL GPS database for specific operation
#' @param Operation Name of operation
#' @param DBType Type of database to get database name for. Value can be 'Main' (default), 'Old' (older version, not available for all operations) or 'NodeJS' (database that feeds online viewer).
#' @return Name of database
#' @export

getGPSDBName <- function(Operation, DBType="Main") {

  Operation <- toupper(Operation)
  DBType <- toupper(DBType)

  ## Get base of DB name
  if (Operation=="CMHAD") {
    dbname="gps_cmhad"
  } else if (Operation=="CMHBB") {
    dbname="gps_cmhbb"
  } else if (Operation=="CMHBU") {
    dbname="gps_cmhbu"
  } else if (Operation=="CMHCA") {
    dbname="gps_cmhca"
  } else if (Operation=="CMHGL") {
    dbname="gps_cmhgl"
  } else if (Operation=="CMHGO") {
    dbname="gps_cmhgo"
  } else if (Operation=="CMHK2") {
    dbname="gps_cmhk2"
  } else if (Operation=="CMHMO") {
    dbname="gps_cmhmo"
  } else if (Operation=="CMHRE") {
    dbname="gps_cmhre"
  } else if (Operation=="CMHVA") {
    dbname="gps_cmhva"
  } else if (Operation=="MPS") {
    dbname="gps_mps"
  } else if (Operation=="NEH") {
    dbname="gps_neh"
  } else if (Operation=="MWHS") {
    dbname <- "gps_mwhs"
  } else if (Operation=="STHS") {
    dbname="gps_sths"
  } else if (Operation=="WHS") {
    dbname="gps_whs"
  } else if (Operation=="BCHS") {
    dbname="gps_bchs"
  } else {
    stop("Invalid value for Operation parameter!")
  }
  
  ## Add extention to DB name
  if(DBType=="MAIN") {}
  else if(DBType=="NODEJS") {dbname <- paste0(dbname, "_online")}
  else if(DBType=="OLD") {dbname <- paste0(dbname, "_old")}
  else {stop("Invalid value for DBType!")}

  return(dbname)
}
