#' Get path of local root folder
#'
#' Get path of local root folder for specific operation and user
#' @param Operation Name of operation. Valid values are 'NEH' and 'MWHS'
#' @param User Name of user. Valid values are 'Pascal' and 'Scott'
#' @return Path of local root folder as character string
#' @export

getLocalRootFolderPath <- function(Operation, User) {

  Operation <- toupper(Operation)
  User <- toupper(User)

## SARP DATABASE SERVER
  if(User=="SARPSERVER") {
    
    RootFolderPathMain <- "Z:\\SARP_DataArchive\\GPSStudy\\"
    
    if (Operation=="CMHAD") {
      RootFolderPath = paste0(RootFolderPathMain, "CMHAD\\")
    } else if (Operation=="CMHBB") {
      RootFolderPath = paste0(RootFolderPathMain, "CMHBB\\")
    } else if (Operation=="CMHBU") {
      RootFolderPath = paste0(RootFolderPathMain, "CMHBU\\")
    } else if (Operation=="CMHCA") {
      RootFolderPath = paste0(RootFolderPathMain, "CMHCA\\")
    } else if (Operation=="CMHGL") {
      RootFolderPath = paste0(RootFolderPathMain, "CMHGL\\")
    } else if (Operation=="CMHGO") {
      RootFolderPath = paste0(RootFolderPathMain, "CMHGO\\")
    } else if (Operation=="CMHK2") {
      RootFolderPath = paste0(RootFolderPathMain, "CMHK2\\")
    } else if (Operation=="CMHMO") {
      RootFolderPath = paste0(RootFolderPathMain, "CMHMO\\")
    } else if (Operation=="CMHRE") {
      RootFolderPath = paste0(RootFolderPathMain, "CMHRE\\")
    } else if (Operation=="CMHVA") {
      RootFolderPath = paste0(RootFolderPathMain, "CMHVA\\")
    } else if (Operation=="MPS") {
      RootFolderPath = paste0(RootFolderPathMain, "MPS\\")
    } else  if(Operation=="MWHS") {
      RootFolderPath = paste0(RootFolderPathMain, "MWHS\\")
    } else if (Operation=="NEH") {
      RootFolderPath = paste0(RootFolderPathMain, "NEH\\")
    } else if (Operation=="STHS") {
      RootFolderPath = paste0(RootFolderPathMain, "STHS\\")
    } else if (Operation=="WHS") {
      RootFolderPath = paste0(RootFolderPathMain, "WHS\\")
    } else if (Operation=="BCHS") {
      RootFolderPath = paste0(RootFolderPathMain, "BCHS\\")
    } else if (Operation=="TEST_NEH") {
      RootFolderPath = paste0(RootFolderPathMain, "TEST_NEH\\")
    } else {
      stop("Invalid value for Operation parameter!")
    }

  ## SARP LAB COMPUTERS
  } else if(User=="SARPLAB") {
    
    RootFolderPathMain <- "R:\\Avalanche\\SARP_DataArchive\\GPSStudy\\"
    
    if (Operation=="CMHAD") {
      RootFolderPath = paste0(RootFolderPathMain, "CMHAD\\")
    } else if (Operation=="CMHBB") {
      RootFolderPath = paste0(RootFolderPathMain, "CMHBB\\")
    } else if (Operation=="CMHBU") {
      RootFolderPath = paste0(RootFolderPathMain, "CMHBU\\")
    } else if (Operation=="CMHCA") {
      RootFolderPath = paste0(RootFolderPathMain, "CMHCA\\")
    } else if (Operation=="CMHGL") {
      RootFolderPath = paste0(RootFolderPathMain, "CMHGL\\")
    } else if (Operation=="CMHGO") {
      RootFolderPath = paste0(RootFolderPathMain, "CMHGO\\")
    } else if (Operation=="CMHK2") {
      RootFolderPath = paste0(RootFolderPathMain, "CMHK2\\")
    } else if (Operation=="CMHMO") {
      RootFolderPath = paste0(RootFolderPathMain, "CMHMO\\")
    } else if (Operation=="CMHRE") {
      RootFolderPath = paste0(RootFolderPathMain, "CMHRE\\")
    } else if (Operation=="CMHVA") {
      RootFolderPath = paste0(RootFolderPathMain, "CMHVA\\")
    } else if (Operation=="MPS") {
      RootFolderPath = paste0(RootFolderPathMain, "MPS\\")
    } else  if(Operation=="MWHS") {
      RootFolderPath = paste0(RootFolderPathMain, "MWHS\\")
    } else if (Operation=="NEH") {
      RootFolderPath = paste0(RootFolderPathMain, "NEH\\")
    } else if (Operation=="STHS") {
      RootFolderPath = paste0(RootFolderPathMain, "STHS\\")
    } else if (Operation=="WHS") {
      RootFolderPath = paste0(RootFolderPathMain, "WHS\\")
    } else if (Operation=="BCHS") {
      RootFolderPath = paste0(RootFolderPathMain, "BCHS\\")
    } else if (Operation=="TEST_NEH") {
      RootFolderPath = paste0(RootFolderPathMain, "TEST_NEH\\")
    } else {
      stop("Invalid value for Operation parameter!")
    }
    
    ## SARP MAC COMPUTER
  } else if(User=="SARPCOMPUTER") {
    
    RootFolderPathMain <- "/Volumes/Avalanche/SARP_DataArchive/GPSStudy/"
    
    if (Operation=="CMHAD") {
      RootFolderPath = paste0(RootFolderPathMain, "CMHAD/")
    } else if (Operation=="CMHBB") {
      RootFolderPath = paste0(RootFolderPathMain, "CMHBB/")
    } else if (Operation=="CMHBU") {
      RootFolderPath = paste0(RootFolderPathMain, "CMHBU/")
    } else if (Operation=="CMHCA") {
      RootFolderPath = paste0(RootFolderPathMain, "CMHCA/")
    } else if (Operation=="CMHGL") {
      RootFolderPath = paste0(RootFolderPathMain, "CMHGL/")
    } else if (Operation=="CMHGO") {
      RootFolderPath = paste0(RootFolderPathMain, "CMHGO/")
    } else if (Operation=="CMHK2") {
      RootFolderPath = paste0(RootFolderPathMain, "CMHK2/")
    } else if (Operation=="CMHMO") {
      RootFolderPath = paste0(RootFolderPathMain, "CMHMO/")
    } else if (Operation=="CMHRE") {
      RootFolderPath = paste0(RootFolderPathMain, "CMHRE/")
    } else if (Operation=="CMHVA") {
      RootFolderPath = paste0(RootFolderPathMain, "CMHVA/")
    } else if (Operation=="MPS") {
      RootFolderPath = paste0(RootFolderPathMain, "MPS/")
    } else  if(Operation=="MWHS") {
      RootFolderPath = paste0(RootFolderPathMain, "MWHS/")
    } else if (Operation=="NEH") {
      RootFolderPath = paste0(RootFolderPathMain, "NEH/")
    } else if (Operation=="STHS") {
      RootFolderPath = paste0(RootFolderPathMain, "STHS/")
    } else if (Operation=="WHS") {
      RootFolderPath = paste0(RootFolderPathMain, "WHS/")
    } else if (Operation=="BCHS") {
      RootFolderPath = paste0(RootFolderPathMain, "BCHS/")
    } else if (Operation=="TEST_NEH") {
      RootFolderPath = paste0(RootFolderPathMain, "TEST_NEH/")
    } else {
      stop("Invalid value for Operation parameter!")
    }
    
    ## Scott Thumlert
  } else if (User=="SCOTT") {
    if(Operation=="MWHS") {
      RootFolderPath = "C:\\Users\\Scott\\Dropbox (Asarc)\\Research\\Post doc SFU\\Data\\"
    } else  if(Operation=="MWHS_OLD") {
        RootFolderPath = "C:\\Users\\Scott\\Dropbox (Asarc)\\Research\\Post doc SFU\\Data\\"
    } else if (Operation=="NEH") {
      RootFolderPath = ""
    } else {
      stop("Invalid value for Operation parameter!")
    }

  } else {
    stop("Invalid value for User parameter! Supported users include 'Pascal', 'Scott', 'SarpServer' and 'SarpComputer'.")
  }

  if(RootFolderPath!="") {
    return(RootFolderPath)
  } else {
    stop("Root folder not specified in function!")
  }

}
