#' Checks tables in NodeJS database and checks whether all columns are there. 
#'
#' Checks tables in NodeJS database and checks whether all columns are there. Shows missing columns for all tables and produces draft of SQL update query. The function does not recoginize if the type definition of a column has changed. It also does not distinguish bentween tables and views. 
#' @param Operation Name of operation
#' 
#' @examples 
#' require(SarpGPSTools)
#' require(SarpGPSToolsPrivate)
#' 
#' Operation <- "CMHGL"
#' checkNodeJSTablesForColumns(Operation)
#'
#' @export

checkNodeJSTablesForColumns <- function(Operation) {

  SchemaListNode <- getRecordsFromQuery(Operation, Query="select * from pg_namespace where nspowner != 10", DBType="NodeJS")$nspname
  
  UpdateQuery <- "\n--UPDATE QUERY FOR NODEJS DATABASE\n--********************************\n"
  
  for (Index_Schema in 1:length(SchemaListNode)) {
    
    TableListNode <- getRecordsFromQuery(Operation, Query=paste0("SELECT * FROM information_schema.tables WHERE table_schema = '", SchemaListNode[Index_Schema], "'"), DBType="NodeJS")$table_name
    
    for (Index_Tbl in 1:length(TableListNode)) {
      
      Query <- paste0("SELECT column_name FROM information_schema.columns WHERE table_name = '", TableListNode[Index_Tbl], "' AND table_schema = '", SchemaListNode[Index_Schema], "'")
      
      TblMain <- getRecordsFromQuery(Operation, Query=Query, DBType="Main")$column_name
      TblNode <- getRecordsFromQuery(Operation, Query=Query, DBType="NodeJS")$column_name
      
      MissingColumns <- TblMain[!(TblMain %in% TblNode)]
      
      String <- paste0(SchemaListNode[Index_Schema], ".", TableListNode[Index_Tbl], ": ")
      
      if (length(MissingColumns)>0) {
        print(paste0(String, "Missing columns (", paste (MissingColumns, collapse = ", "), ")"))
        
        # print(paste0("Main: ", paste(names(TblMain), collapse = ", ")))
        # print(paste0("Node: ", paste(names(TblNode), collapse = ", ")))
        # print(paste0("Miss: ", paste(MissingColumns, collapse = ", ")))
        # 
        UpdateQuery <- paste0(UpdateQuery, "\n--", SchemaListNode[Index_Schema], ".", TableListNode[Index_Tbl], "\n")
        
        for (Index_Col in 1:length(MissingColumns)) {
          
          ColInfo <- getRecordsFromQuery(Operation, Query=paste0("SELECT column_name, udt_name, character_maximum_length FROM information_schema.columns WHERE table_name = '", TableListNode[Index_Tbl], "' AND table_schema = '", SchemaListNode[Index_Schema], "' AND column_name='", MissingColumns[Index_Col],"'"))
          
          UpdateQuery <- paste0(UpdateQuery, "ALTER TABLE \"", SchemaListNode[Index_Schema], "\".\"", TableListNode[Index_Tbl], "\" ADD COLUMN \"",  ColInfo$column_name, "\" ", ColInfo$udt_name[1], ifelse(ColInfo$udt_name[1]=="varchar", paste0("(", ColInfo$character_maximum_length, ")"), ""), ";\n")
          
        }
        
      } else {
        print(paste0(String, "No missing columns"))
      }
      
    }
    
  }
  
  cat(UpdateQuery)
  
}

