#' Check run characterization answers for completeness.
#'
#' Check run characterization answers for completeness.
#' @param RunCharAssess Data frame from runchar.assessments.
#' @param Operation Operation.
#' @param LinesExist Data frame with existing lines per on ski run.
#' @return data frame with evaluation.
#' @examples 
#' ## MAKE CONTROL DATA FRAME WITH EXISTING SKI LINES ON A SKI RUN (yes/NA)
#' Operation <- "NEH"
#' RunListForm <- getRunListForm(Operation)
#' ifelse(Operation=="NEH", RunListForm <- RunListForm[RunListForm$zone_name=="Promised Land",], RunListForm)
#' TblSkiRuns  <- getRecordsFromQuery(Operation, "SELECT uuid, terrain_class1, terrain_class2, terrain_class3 FROM loccat.skiruns")
#' TblSkiLines <- getRecordsFromQuery(Operation, "SELECT uuid, terrain_class1, terrain_class2, terrain_class3  FROM loccat.skilines")
#' a <- merge(RunListForm, TblSkiRuns, by.x="loc_uuid", by.y="uuid")
#' b <- merge(RunListForm, TblSkiLines, by.x="loc_uuid", by.y="uuid")
#' DF <- rbind(a,b)
#' DF <- DF[order(DF$loc_order),]
#' rm(a,b,TblSkiRuns,TblSkiLines)
#' DF$line_c <- DF$terrain_class1
#' DF$line_t <- DF$terrain_class2
#' DF$line_a <- DF$terrain_class3
#' 
#' DF <- DF[,c("loc_uuid", "line_c", "line_t", "line_a")]
#'
#' ## RETREIVE FROM DATABASE
#' RunCharAssess <- getRecordsFromUUID(Operation, "runchar", "assessments")
#' 
#' ## RETREIVE FROM DATABASE
#' QC <- checkRunCharForMissingData(RunCharAssess=RunCharAssess, LinesExist=DF, Operation=Operation)
#'
#' @export


checkRunCharForMissingData <- function(RunCharAssess, LinesExist, Operation){
  
  if (!(Operation=="NEH")){
    stop("Not working yet for other than operation NEH")
  }
  
  
  DF <- LinesExist
  DF$line_c <- ifelse(DF$line_c=="Yes", "c", NA)
  DF$line_t <- ifelse(DF$line_t=="Yes", "t", NA)
  DF$line_a <- ifelse(DF$line_a=="Yes", "a", NA)
  
  ## GET QUESTION CODES 
  ## ******************
  QDef <- getRecordsFromQuery(Operation, "SELECT * FROM runchar.questions")
  QCodesWithOutLines <- QDef[is.na(QDef$linelevels),]$code
  QCodesWithLines <- QDef[!is.na(QDef$linelevels),]$code
  
  ## CREATE DF FOR SUMMARY OF DATA CHECK
  ## ***********************************
  output <- setNames(data.frame(matrix(ncol = length(QDef$code)+2, nrow = nrow(RunCharAssess))), c("loccat_uuid", "loc_name", QDef$code))
  
  ## LOOP OVER SKI RUNS IN ASSESSMENTS TABLE
  ## ***************************************
  for (i in 1:nrow(RunCharAssess)){
    
    checkDF <- RunCharAssess[i,,drop=F]
    runUUID <- ifelse(is.na(checkDF$loccatskiruns_uuid), checkDF$loccatskilines_uuid, checkDF$loccatskiruns_uuid)
    output$loccat_uuid[i] <- runUUID
    output$loc_name[i] <- DF[DF$loc_uuid==runUUID,]$loc_name
    print(paste0("Checking '", DF[DF$loc_uuid==runUUID,]$loc_name, "' for missing data..."))
    
    ## GET EXISTING LINES ON SKI RUN
    ## -----------------------------
    LineLevels <- paste(DF[DF$loc_uuid==runUUID,]$line_c,DF[DF$loc_uuid==runUUID,]$line_t,DF[DF$loc_uuid==runUUID,]$line_a, sep=",")
    lev <- strsplit(LineLevels, ",")[[1]]
    lev <- lev[!(lev=="NA")]
    
    ## CHECK NUMBER OF NON-EMPTY ANSWER COLUMNS FOR QUESTIONS ON LINE LEVEL
    ## --------------------------------------------------------------------
    for (q in 1:length(QCodesWithLines)){
      QColNames <- getRunCharQuestColNames(QuestCode=QCodesWithLines[q], Operation=Operation, ElevLevels="all", AssessTblFormatted=F)
      if(length(lev) == sum(!is.na(checkDF[,QColNames]))){
        flag <- "All Lines answered"
      } else {
        flag <- "Lines missing"
      }
      output[i,QCodesWithLines[q]] <- flag
    }
    ## CHECK IF ALL OTHER QUESTIONS WERE ANSWERED
    ## ------------------------------------------
    for (q in 1:length(QCodesWithOutLines)){
      if(!is.na(checkDF[,QCodesWithOutLines[q]])){
        flag <- "Answered"
      } else {
        flag <- "not answered"
      }
      output[i,QCodesWithOutLines[q]] <- flag
    }
  }
  
  return(output)
}