#' Converts numeric aspect to categorical aspect
#'
#' Converts numeric aspect to categorical aspect
#' @param Aspect Numerical aspect value
#' @return Factor with categorical aspect values with either four or eight categories. Default values is 4.
#' @export

convertAspectToAspectCat <- function(Aspect, NumCat=4) {
  
  if (NumCat==4) {
  
    AspectCat <- rep(NA, length(Aspect))
    AspectCat <- ifelse(Aspect > 315 | Aspect <=  45, "N", AspectCat)
    AspectCat <- ifelse(Aspect >  45 & Aspect <= 135, "E", AspectCat)
    AspectCat <- ifelse(Aspect > 135 & Aspect <= 225, "S", AspectCat)
    AspectCat <- ifelse(Aspect > 225 & Aspect <= 315, "W", AspectCat)
    AspectCat <- factor(AspectCat, levels = c("N", "E", "S", "W"))

  } else if (NumCat==8) {
    
    AspectCat <- rep(NA, length(Aspect))
    AspectCat <- ifelse(Aspect > 337.5 | Aspect <=  22.5, "N", AspectCat)
    AspectCat <- ifelse(Aspect >  22.5 & Aspect <=  67.5, "NE", AspectCat)
    AspectCat <- ifelse(Aspect >  67.5 & Aspect <= 112.5, "E", AspectCat)
    AspectCat <- ifelse(Aspect > 112.5 & Aspect <= 157.5, "SE", AspectCat)
    AspectCat <- ifelse(Aspect > 157.5 & Aspect <= 202.5, "S", AspectCat)
    AspectCat <- ifelse(Aspect > 202.5 & Aspect <= 247.5, "SW", AspectCat)
    AspectCat <- ifelse(Aspect > 247.5 & Aspect <= 292.5, "W", AspectCat)
    AspectCat <- ifelse(Aspect > 291.5 & Aspect <= 337.5, "NW", AspectCat)
    AspectCat <- factor(AspectCat, levels = c("N", "NE", "E", "SE", "S", "SW", "W", "NW"))

  } else {
    
    stop("Incorrect value for NumCat parameter! This parameter must either be 4 or 8.")
    
  }
    
  return(AspectCat)
  
}
