#' Converts avalanche problem labels from Infoex into standard labels
#'
#' Converts avalanche problem labels from Infoex into standard labels
#' @param AvProbInfoEx Avalanche Problem label from InfoEx
#' @return Standard avalanche problem label
#'
#' @export
#' 
#' @examples
#' require(SarpGPSTools)
#' require(SarpGPSToolsPrivate)
#' 
#' Operation <- "NEH"
#' Query <- "SELECT Count(infoex.hzdassess_avprob.uuid), infoex.hzdassess_avprob.character FROM infoex.hzdassess_avprob GROUP BY infoex.hzdassess_avprob.character"
#' 
#' AvProblemCounts <- getRecordsFromQuery(Operation, Query)
#' AvProblemCounts$AvProbLabel <- convertAvProbLabelFromInfoEx(AvProblemCounts$character)


convertAvProbLabelFromInfoEx <- function(AvProbInfoEx) {
  
  ## Function definition for single value
  convertAvProbLabelFromInfoExSingle <- function(AvProbInfoEx) {
    
    AvProbInfoEx <- toupper(AvProbInfoEx)
    
    if(is.na(AvProbInfoEx)) {
      AvProbLabel <- NA
    } else if (AvProbInfoEx %in% toupper(AvProblemTypes$Label)) {
      AvProbLabel <- AvProblemTypes$Label[toupper(AvProblemTypes$Label)==AvProbInfoEx]
    } else if (AvProbInfoEx %in% toupper(AvProblemTypes$InfoEx)) {
      AvProbLabel <- AvProblemTypes$Label[toupper(AvProblemTypes$InfoEx)==AvProbInfoEx]
    } else {
      AvProbLabel <- NA
      warning(paste0("Avalanche problem type '", AvProbInfoEx, " not supported! Check spelling!"), immediate.=T)
    }
    
    return (AvProbLabel)
  }
  
  ## Application of function to array
  AvProbLabel <- sapply(AvProbInfoEx, convertAvProbLabelFromInfoExSingle)
  
  ## Turn into factor
  AvProbLabel <- factor(AvProbLabel, levels = AvProblemTypes$Label)
  
  return(AvProbLabel)
  
}
