#' Counts all records in all tables in gps schema in PostgreSQL/PostGIS GPS database
#'
#' Counts all records in all tables in gps schema in PostgreSQL/PostGIS GPS database. Returns dataframe with number of records in each relevant table.
#' @param Operation Name of operation
#' @param DBType Type of database to count records. Can be 'Main' (default), 'Old' or 'NodeJS' for database that feeds online viewer
#' @param Verbose Switch for printing of query
#' @param SuppressPostgreSQLWarnings Switch for turning warnings off. Default value is TRUE
#' @return Dataframe with counting results.
#' @export

countGPSRecords <- function(Operation, DBType="Main", Verbose=F, SuppressPostgreSQLWarnings=T) {

  DBType <- toupper(DBType)
  
  ## Create Output DF
  DF_Output <- data.frame(Table = character(0),
                         NumRec = numeric(0))

  ## 1) gps.obspoints
  if(DBType=="MAIN"){
    Query  <- "SELECT Count(gps.obspoints.uuid) AS \"Count\" FROM gps.obspoints"
    DF_Output <- rbind(DF_Output, data.frame(Table="gps.obspoints",
                                             NumRec=getRecordsFromQuery(Operation, Query, DBType=DBType, Verbose=Verbose, SuppressPostgreSQLWarnings=SuppressPostgreSQLWarnings)$Count[1]))
  } else {
    DF_Output <- rbind(DF_Output, data.frame(Table="gps.obspoints",
                                             NumRec=0))
  }

  ## 2) gps.runs_pausepoints
  Query <- "SELECT Count(gps.runs_pausepoints.uuid) AS \"Count\" FROM gps.runs_pausepoints"
  DF_Output <- rbind(DF_Output, data.frame(Table="gps.runs_pausepoints",
                                           NumRec=getRecordsFromQuery(Operation, Query, DBType=DBType, Verbose=Verbose, SuppressPostgreSQLWarnings=SuppressPostgreSQLWarnings)$Count[1]))

  ## 3) gps.runs
  Query <- "SELECT Count(gps.runs.uuid) AS \"Count\" FROM gps.runs"
  DF_Output <- rbind(DF_Output, data.frame(Table="gps.runs",
                                           NumRec=getRecordsFromQuery(Operation, Query, DBType=DBType, Verbose=Verbose, SuppressPostgreSQLWarnings=SuppressPostgreSQLWarnings)$Count[1]))

  ## 4) gps.potruns_skipped
  if(DBType=="MAIN"){
    Query <- "SELECT Count(gps.potruns_skipped.uuid) AS \"Count\" FROM gps.potruns_skipped"
    DF_Output <- rbind(DF_Output, data.frame(Table="gps.potruns_skipped",
                                             NumRec=getRecordsFromQuery(Operation, Query, DBType=DBType, Verbose=Verbose, SuppressPostgreSQLWarnings=SuppressPostgreSQLWarnings)$Count[1]))
  } else {
    DF_Output <- rbind(DF_Output, data.frame(Table="gps.potruns_skipped",
                                             NumRec=0))
  }
  
  ## 5) gps.tracks_days
  Query <- "SELECT Count(gps.tracks_days.uuid) AS \"Count\" FROM gps.tracks_days"
  DF_Output <- rbind(DF_Output, data.frame(Table="gps.tracks_days",
                                           NumRec=getRecordsFromQuery(Operation, Query, DBType=DBType, Verbose=Verbose, SuppressPostgreSQLWarnings=SuppressPostgreSQLWarnings)$Count[1]))

  ## 6) gps.tracks
  Query <- "SELECT Count(uuid) AS \"Count\" FROM gps.tracks"
  DF_Output <- rbind(DF_Output, data.frame(Table="gps.tracks",
                                           NumRec=getRecordsFromQuery(Operation, Query, DBType=DBType, Verbose=Verbose, SuppressPostgreSQLWarnings=SuppressPostgreSQLWarnings)$Count[1]))

  ## Return DF
  return(DF_Output)

}
