#' Create sp spatial line from list of coordinates
#'
#' Retrieves spatial objects from MySQL and turns them into sp spatial objects. See http://www.maths.lancs.ac.uk/~rowlings/Teaching/UseR2012/cheatsheet.html for details
#' @param DF Dataframe with coordinate columns
#' @param ID ID for spatial line
#' @param x Name of column with x coordinate
#' @param y Name of column with y coordinate
#' @param CRS_String String with the information about the coordinate reference system in CRS format
#' @return sp spatial lines object with a single line
#' @export

createSpatialLineFromCoord <- function(DF, ID, x="lon", y="lat", CRS_String=Const_GlobalCrsString) {

  ## Creating data frame with only coordinates
  Coord <- DF[,c(x, y)]

  ## Creating Spatial Lines
  Line <- Line(Coord)
  LineString <- Lines(list(Line), ID=ID)
  LineStringList <- list(LineString)
  SpatialLines <- SpatialLines(LineStringList)

  ## Add CRS information
  proj4string(SpatialLines) <- CRS_String

  ## Return SpatialLines
  return (SpatialLines)

}
