#' Create sp spatial points from list of coordinates
#'
#' Retrieves spatial objects from MySQL and turns them into sp spatial objects. See http://www.maths.lancs.ac.uk/~rowlings/Teaching/UseR2012/cheatsheet.html for details
#' @param DF Dataframe with coordinate columns
#' @param x Name of column with x coordinate
#' @param y Name of column with y coordinate
#' @param CRS_String String with the information about the coordinate reference system in CRS format
#' @return sp spatial points object with one or multiple points
#' @export

createSpatialPointsFromCoord <- function(DF, x="lon", y="lat", CRS_String=Const_GlobalCrsString) {

  ## Creating data frame with only coordinates
  Coord <- DF[,c(x, y)]

  ## Creating Spatial Points
  SpatialPoints <- SpatialPoints(Coord)

  ## Add CRS information
  proj4string(SpatialPoints) <- CRS_String

  ## Return SpatialLines
  return (SpatialPoints)

}
