#' Deletes reference for raster and array table for extracted values in DB
#'
#' Deletes new reference for raster and array table for extracted values in DB.
#' @param Operation Name of Operation. Used for accessing PostgreSQL database.
#' @param RasterName Name of raster.
#' @param DBType Parameter for specifying for which database type to delete the raster referenand array table. Values can be 'Main' (default), 'NodeJS' or 'Old'.
#' @param Verbose Switch for printing SQL query. Default value is FALSE.
#' @param SuppressPostgreSQLWarnings Switch for turning warnings off. Default value is TRUE.
#'
#' @export

deleteRasterRefAndArrayTbl <- function(Operation, RasterName, DBType="Main", Verbose=F, SuppressPostgreSQLWarnings=T) {

  ## Check whether reference entry exists
  ExistingRef <- getRecordsFromQuery(Operation, paste0("Select * from misc.rasters WHERE Name='", RasterName, "';"), DBType=DBType)

  ## If reference entry exists
  if (nrow(ExistingRef)>0) {

    ## Delete reference entry
    Query <- paste0("DELETE FROM misc.rasters WHERE Name='", RasterName, "';")
    sendQueryToGPSDB(Operation, Query, DBType=DBType, Verbose=Verbose, SuppressPostgreSQLWarnings=SuppressPostgreSQLWarnings)

    ## Check whether array table exists
    GISTblName <- paste0("gpsruns_array_", ExistingRef$gis_array_name_ext)

    ExistingTbl <- getRecordsFromQuery(Operation, paste0("SELECT table_name FROM information_schema.tables WHERE table_schema = 'gis' and table_name='", GISTblName, "';"), DBType=DBType)

    ## If array table exists
    if (nrow(ExistingTbl)>0) {

      ## Delete array table
      Query <- paste0("DROP TABLE gis.", GISTblName, ";")
      sendQueryToGPSDB(Operation, Query, DBType=DBType, Verbose=Verbose, SuppressPostgreSQLWarnings=SuppressPostgreSQLWarnings)

    } else {

      warning(paste0("No array table was deleted, because none exists for the name '", GISTblName, "'!"), immediate.=T)

    }

  } else {

    stop(paste0("Nothing was delete, because no raster reference was found for '", RasterName, "'!"))

  }


}
