#' Deletes views from PostgrSQL/PostGIS GPS database.
#'
#' Deletes views from PostgrSQL/PostGIS GPS database.
#' @param Operation Name of operation
#' @param Schema Name of schema, which contains view.
#' @param ViewName Name of view to be deleted.
#' @param DBType Parameter for specifying for which database type to delete the view from. Values can be 'Main' (default), 'NodeJS' or 'Old'. 
#' @param ShowList Switch for specifying whther list of views should be shown after deletion. Default value is TRUE.
#' @param Verbose Switch for printing of query
#' @param SuppressPostgreSQLWarnings Switch for suppressing warning messages from postgresqlExecStatement. Turn on for debugging!
#'
#' @export

deleteViews <- function(Operation, Schema, ViewName, DBType="Main", ShowList=T, Verbose=F, SuppressPostgreSQLWarnings=T) {


  ## Check list of existing views
  Query <- paste0("SELECT pg_class.relname as name, obj_description(pg_class.oid) as comment ",
                  "FROM pg_class INNER JOIN information_schema.tables ON pg_class.relname=information_schema.tables.table_name ",
                  "WHERE information_schema.tables.table_schema = '", Schema, "' and information_schema.tables.table_type='VIEW' ",
                  "ORDER BY information_schema.tables.table_name")

  ListViews <- getRecordsFromQuery(Operation, Query, DBType=DBType)$name

  ## Delete views
  if (ViewName=="qc_runs" | ViewName=="qc_runs_pausepoints") {

    warning(paste0("You cannot delete the view '", ViewName, "' in schema '", Schema, "'!"), immediate.=T)

  } else if (ViewName %in% ListViews) {

    Query <- paste0("DROP VIEW ", Schema, ".", ViewName, ";")
    sendQueryToGPSDB(Operation, Query, DBType=DBType, Verbose=Verbose, SuppressPostgreSQLWarnings=SuppressPostgreSQLWarnings)

  } else {

    warning(paste0("No view of name '", ViewName, "' available in '", Schema, "' schema."), immediate.=T)

  }

  ## List remaining views
  if(ShowList) {
    listDBTblsViews(Operation, TblType="View", Schema=Schema, DBType=DBType)
  }

}
