#' Extract raster values from list of coordinates
#'
#' Extract raster values from list of coordinates
#' @param Raster Object of class 'RasterLayer' (package raster)
#' @param CoordDF Dataframe with coordinates in columns 'lon'/'x' and 'lat'/'y'.
#' @param Method Method for extraction of raster values. Must be 'simple' or 'bilinear'. See help for raster::extract for more detail.
#' @return Array with extracted values
#'
#' @export

extractRasterValuesFromCoord <- function(Raster, CoordDF, Method="simple") {
  
  ## Methods
  if (Method!="simple" & Method!="bilinear") {
    stop("Value of Method parameter must be 'simple' or 'bilinear'! See help for raster::extract for more detail.")
  }
  
  ## Get coordinate columns
  LonColNumber <- which(names(CoordDF)=="lon"|names(CoordDF)=="x")
  LatColNumber <- which(names(CoordDF)=="lat"|names(CoordDF)=="y")
  
  ## Extract values
  RasterValues <- extract(Raster, CoordDF[,c(LonColNumber, LatColNumber)], Method)
  
  return(RasterValues)  

}
