#' Gets array table for loccation catalog skiruns from PostgreSQL/PostGIS GPS database in useable format for R.
#'
#' Gets array table for loccation catalog skiruns from PostgreSQL/PostGIS GPS database in useable format for R. IMPORTANT: To assess array values of individual row use 'ArrayTbl[Index][[1]]' command.
#' @param Operation Name of Operation
#' @param RasterName Name of raster of array table
#' @param UUID Single or array of UUIDs. Default value is NA, which returns entire table.
#' @param DBType Optional parameter to specify which database type to get the array table from. Values can be 'Main' (default) or 'NodeJS'.
#' @param Verbose Switch for printing of query
#' @param SuppressPostgreSQLWarnings Switch for suppressing warning messages from postgresqlExecStatement. Turn on for debugging!

#' @return Array Table as dataframe with value array as a vector.
#' @export

getArrayTblFromUUIDLoccatSkiruns <- function(Operation, RasterName, UUID=NA, DBType="Main", Verbose=F, SuppressPostgreSQLWarnings=T) {

  ## Determine name of array table
  ExistingRef <- getRecordsFromQuery(Operation, paste0("Select * from misc.rasters WHERE Name='", RasterName, "';"), DBType=DBType)

  if (nrow(ExistingRef)==0) {

    stop("No array table exists for raster '", RasterName, "'!")

  } else {

    ArrayTblName <- paste0("loccatskiruns_array_", ExistingRef$gis_array_name_ext)
    ArrayTbl <- getRecordsFromUUID(Operation, "gis", ArrayTblName, UUID=UUID, UUIDCol="loccatskiruns_uuid", ResultCol="valuearray", DBType=DBType, Verbose=F, SuppressPostgreSQLWarnings=T, SuppressOrderWarning=T)

    if (is.na(UUID[1])) {
      ArrayTbl$valuearray <- sapply(ArrayTbl$valuearray, function (x) convertArrayFromSQL(x))
    } else if (length(UUID)==0) {
      stop("UUID array of length zero.")
    } else if (length(UUID)==1) {
      ArrayTbl$valuearray <- list(convertArrayFromSQL(ArrayTbl$valuearray))
    } else {
      ArrayTbl$valuearray <- sapply(ArrayTbl$valuearray, function (x) convertArrayFromSQL(x))
    }

  }

    return(ArrayTbl)

}
