#' Get elevation band boundary for operation.
#'
#' Gets elevation band boundary for operation from misc.elevationbans table in database.
#' @param Operation Name of operation
#' @param ElevBand Name of elevation band. Needs to be ALP, TL or BTL.
#' @param TopOrBottom Flag whether top or bottom boundary of elevation band is extracted. Value need to be 'Top' (default) or 'Bottom'.
#' @return Elevation of elevation band boundary.
#' @export

getElevBandBoundary <- function(Operation, ElevBand, TopOrBottom="Top") {

  if (toupper(ElevBand)=="ALP" | toupper(ElevBand)=="TL" | toupper(ElevBand)=="BTL") {
    if(toupper(TopOrBottom)=="TOP") {
      Query <- paste0("SELECT max as elev FROM misc.elevbands WHERE name='", toupper(ElevBand), "';")
    } else if (toupper(TopOrBottom)=="BOTTOM") {
      Query <- paste0("SELECT min as elev FROM misc.elevbands WHERE name='", toupper(ElevBand), "';")
    } else {
      stop("Incorrect value for parameter TopOrBottom!")
    }
  } else {
    stop("Incorrect value for parameter ElevBand!")
  }

  Result <- getRecordsFromQuery(Operation, Query)

  return(Result$elev)

}
