#' Get size of Postgres database
#'
#' Get size of Postgres database. The function countGPSRecordsMultiple() is a wrapper function that applies this function to all GPS databases at the same time.
#' @param Operation Name of operation
#' @param Verbose Switch for printing of query. Default value is FALSE.
#' @param SuppressPostgreSQLWarnings Switch for turning warnings off. Default value is TRUE.
#' @return Size in pretty format
#' @export

getGPSDBSize <- function(Operation, DBType="Main", Verbose=F, SuppressPostgreSQLWarnings=T) {

  DBType <- toupper(DBType)
  DBName <- getGPSDBName(Operation, DBType=DBType)
  
  Query <- paste0("select pg_size_pretty(pg_database_size('", DBName, "')) as db_size")
  if (Verbose) {print(Query)}

  DBSize <- getRecordsFromQuery(Operation, Query, DBType, Verbose, SuppressPostgreSQLWarnings)

  return(DBSize$db_size)

}
