#' Get InfoEx weather observations from PostgreSQL/PostGIS GPS database.
#'
#' Get InfoEx weather observations from PostgreSQL/PostGIS GPS database for a single weather site.
#' @param Operation Name of operation
#' @param WxSiteName Single location name of weather site.
#' @param DBType Optional variable for specifying which database type the location catalog should be imported. Values can be 'Main' (default) or 'NodeJS
#' @param DateStart Start date in YYYY-MM-DD format. Default value is NA. 
#' @param DateEnd End date in YYYY-MM-DD format. Default value is DateStart.
#' @param Time For specifing time of day of InfoEx weather observations. Values can be 'All' (default), 'AM' or 'PM'.

#' @export

getInfoExWxObs <- function(Operation, WxSiteName, DBType="Main", DateStart=NA, DateEnd=DateStart, Time="ALL") {
  
  Time <- toupper(Time)
  
  if(is.na(DateStart)) {
    
    if(Time=="ALL"){
      Query <- paste0("SELECT infoex.wxobs.* ", 
                      "FROM infoex.wxobs INNER JOIN loccat.wxsites ON infoex.wxobs.loccatwxsites_uuid = loccat.wxsites.uuid ",
                      "WHERE loccat.wxsites.name = '",WxSiteName , "' ", 
                      "ORDER BY infoex.wxobs.datetime ASC") 
    } else if(Time=="AM"){
      Query <- paste0("SELECT infoex.wxobs.* ", 
                      "FROM infoex.wxobs INNER JOIN loccat.wxsites ON infoex.wxobs.loccatwxsites_uuid = loccat.wxsites.uuid ",
                      "WHERE loccat.wxsites.name = '",WxSiteName , "' ", 
                      "AND extract(hour from infoex.wxobs.datetime) < 12 ",
                      "ORDER BY infoex.wxobs.datetime ASC") 
    } else if(Time=="PM"){
      Query <- paste0("SELECT infoex.wxobs.* ", 
                      "FROM infoex.wxobs INNER JOIN loccat.wxsites ON infoex.wxobs.loccatwxsites_uuid = loccat.wxsites.uuid ",
                      "WHERE loccat.wxsites.name = '",WxSiteName , "' ", 
                      "AND extract(hour from infoex.wxobs.datetime) >= 12 ",
                      "ORDER BY infoex.wxobs.datetime ASC") 
    } else {
      stop("Value for Time parameter not supported!")
    }
    
  } else {
    
    if(Time=="ALL"){
      Query <- paste0("SELECT infoex.wxobs.* ", 
                      "FROM infoex.wxobs INNER JOIN loccat.wxsites ON infoex.wxobs.loccatwxsites_uuid = loccat.wxsites.uuid ",
                      "WHERE loccat.wxsites.name = '",WxSiteName , "' ", 
                      "AND infoex.wxobs.date >= '", DateStart, "' AND infoex.wxobs.date <= '", DateEnd, "' ",
                      "ORDER BY infoex.wxobs.datetime ASC")
    } else if(Time=="AM"){
      Query <- paste0("SELECT infoex.wxobs.* ", 
                      "FROM infoex.wxobs INNER JOIN loccat.wxsites ON infoex.wxobs.loccatwxsites_uuid = loccat.wxsites.uuid ",
                      "WHERE loccat.wxsites.name = '",WxSiteName , "' ", 
                      "AND infoex.wxobs.date >= '", DateStart, "' AND infoex.wxobs.date <= '", DateEnd, "' ",
                      "AND extract(hour from infoex.wxobs.datetime) < 12 ", 
                      "ORDER BY infoex.wxobs.datetime ASC")
    } else if(Time=="PM"){
      Query <- paste0("SELECT infoex.wxobs.* ", 
                      "FROM infoex.wxobs INNER JOIN loccat.wxsites ON infoex.wxobs.loccatwxsites_uuid = loccat.wxsites.uuid ",
                      "WHERE loccat.wxsites.name = '",WxSiteName , "' ", 
                      "AND infoex.wxobs.date >= '", DateStart, "' AND infoex.wxobs.date <= '", DateEnd, "' ",
                      "AND extract(hour from infoex.wxobs.datetime) >= 12 ", 
                      "ORDER BY infoex.wxobs.datetime ASC")
    } else {
      stop("Value for Time parameter not supported!")
    }
    
  }
  
  TblWx <- getRecordsFromQuery(Operation, Query, DBType=DBType)
  return(TblWx)
  
}

