#' Gets local SRID specification stored in DB
#'
#' Gets record from database based on SQL query
#' @param Operation Name of operation
#' @return Dataframe with result: column names are srid (number format) and proj4text (text format)
#' @export

getLocalSRDI <- function(Operation) {

  Query <- paste0("SELECT \"public\".spatial_ref_sys.srid, \"public\".spatial_ref_sys.proj4text ",
                  "FROM misc.local_srdi ",
                  "INNER JOIN \"public\".spatial_ref_sys ON misc.local_srdi.srdi = \"public\".spatial_ref_sys.srid")

  ResultDF <- getRecordsFromQuery(Operation, Query)

  return(ResultDF)
}
