#' Get raster file
#'
#' Gets raster file of specific type.
#' @param Operation Name of operation
#' @param User Name of user. Required for local root folder. Default value is 'SARPLab'.
#' @param Type Name of raster file type
#' @param DBType Type of database the raster reference should be retrieved from. Can be 'Main' (default) or 'NodeJS' for database that feeds online viewer.
#' @param Verbose Switch for printing of query. Default value is FALSE.
#' @param SuppressPostgreSQLWarnings Switch for turning warnings off. Default value is TRUE.
#' @return Raster object
#' @export

getRaster <- function(Operation, User="SARPLab", Type, DBType="Main", Verbose=F, SuppressPostgreSQLWarnings=T) {

  Query <- paste0("SELECT * FROM misc.rasters WHERE name='", Type, "'")
  if (Verbose) {print(Query)}

  RasterInfo <- getRecordsFromQuery(Operation=Operation, Query=Query, DBType=DBType, Verbose=Verbose, SuppressPostgreSQLWarnings=SuppressPostgreSQLWarnings)

  if (nrow(RasterInfo)==0) {
    stop(paste0("No raster of type '", Type, "' available!"))
  } else if (nrow(RasterInfo)>1) {
    stop(paste0("Multile database records for raster type '", Type, "'!"))
  } else {
    FileName <- paste0(getLocalRootFolderPath(Operation, User),
                       ifelse(is.na(RasterInfo$subfolder[1]), "", paste0(RasterInfo$subfolder[1], createOSSpecFolderLink())),
                       RasterInfo$file_name[1])    
    Raster <- raster(FileName)
  }

  return(Raster)

}
