#' Gets record from database based on SQL query
#'
#' Gets record from database based on SQL query
#' @param Operation Name of operation for accessing correct database
#' @param Query Propertly formatted SQL query
#' @param DBType Type of database to query from. Can be 'Main' (default) or 'NodeJS' for database that feeds online viewer.
#' @param Verbose Switch for printing SQL query. Default value is FALSE.
#' @param SuppressPostgreSQLWarnings Switch for turning warnings off. Default value is TRUE.
#' @param MaxNumTries Number of maximum tries that are attempted. Default value is 10.
#' @return Dataframe with result
#' @export

getRecordsFromQuery <- function(Operation, Query, DBType="Main", Verbose=F, SuppressPostgreSQLWarnings=T, MaxNumTries=10) {

  if(Verbose) {cat(Query, "\n")}

  if (SuppressPostgreSQLWarnings) {options(warn=-1)}

  DBCon <- tryMultipleTimes(connectToGPSDB(Operation, DBType=DBType), MaxNumTries=MaxNumTries)

  Result <- dbSendQuery(DBCon, Query)
  ResultDF <- dbFetch(Result,-1)
  dbClearResult(Result)

  dbDisconnect(DBCon)
  rm(DBCon)

  if (SuppressPostgreSQLWarnings) {options(warn=0)}

  return(ResultDF)
}
