#' Gets record from terrain survey database based on SQL query
#'
#' Gets record from terrain survey database based on SQL query
#' @param Query Propertly formatted SQL query
#' @param Verbose Switch for printing SQL query. Default value is FALSE.
#' @param SuppressPostgreSQLWarnings Switch for turning warnings off. Default value is TRUE.
#' @param MaxNumTries Number of maximum tries that are attempted. Default value is 10.
#' @return Dataframe with result
#' @export

getRecordsFromQueryTerrainSurvey <- function(Query, Verbose=F, SuppressPostgreSQLWarnings=T, MaxNumTries=10) {
  
  if(Verbose) {cat(Query, "\n")}
  
  if (SuppressPostgreSQLWarnings) {options(warn=-1)}
  
  DBCon <- tryMultipleTimes(connectToTerrainSurveyDB(), MaxNumTries=MaxNumTries)
  
  Result <- dbSendQuery(DBCon, Query)
  ResultDF <- dbFetch(Result,-1)
  dbClearResult(Result)
  
  dbDisconnect(DBCon)
  rm(DBCon)
  
  if (SuppressPostgreSQLWarnings) {options(warn=0)}
  
  return(ResultDF)
}
