#' Calculate frequencies of answers.
#'
#' Calculate frequencies of answers.
#' @param RunCharAssessQuestion Formated data frame.
#' @param transformToMinimalLine Switch for transformed answers to minimal comitting line (default=F).
#' @param QuestCode Question code.   
#' @return Formatted dataframe.
#' @examples 
#' require(SarpGPSTools)
#' require(SarpGPSToolsPrivate)
#' 
#' Operation <- "NEH"
#' RunChar <- getRecordsFromUUID(Operation, "runchar", "assessments")
#' QuestDef <- getRecordsFromQuery(Operation, "SELECT * FROM runchar.questions")
#' LineLevels <- convertArrayFromSQL(QuestDef[QuestDef$code==QuestCode,]$linelevels,Numeric=F)
#' ElevLevels <- convertArrayFromSQL(QuestDef[QuestDef$code==QuestCode,]$elevlevels,Numeric=F)
#' QuestEnum <- getRecordsFromQuery(Operation, paste0("SELECT * FROM runchar.enum_", QuestCode))
#' RunCharMinRelevantSkiLine <- getRunCharMinRelevantSkiLine(Operation=Operation)
#' 
#' QuestColNames <- getRunCharQuestColNames(QuestCode=QuestCode, Operation=Operation, AssessTblFormatted=F, ElevLevels=ElevLevels)
#' RunCharCompact <- RunChar[,c("uuid", "loccatskiruns_uuid","loccatskilines_uuid", QuestColNames)]
#' RunCharCompact <- formatRunCharAssessmentDF(Operation, RunCharCompact)
#' 
#' FreqTbl_Ref <- getRunCharAnswerFreqTbl(RunCharCompact, transformToMinimalLine=T, Operation=Operation, QuestCode=QuestCode, QuestDef=QuestDef, RunCharMinRelevantSkiLine=RunCharMinRelevantSkiLine, QuestEnum=QuestEnum)
#' 
#' 
#' 
#' @export
 

getRunCharAnswerFreqTbl <- function(RunCharAssessQuestion, transformToMinimalLine=F, QuestCode, Operation, QuestDef, RunCharMinRelevantSkiLine=NULL, QuestEnum){
  
  IDCol <- c("uuid", "loccatskiruns_uuid", "loccatskilines_uuid", "order")
  df <- RunCharAssessQuestion[,!(names(RunCharAssessQuestion) %in% IDCol),drop=F]

  LineLevels <- SarpGeneral::convertArrayFromSQL(QuestDef[QuestDef$code==QuestCode,]$linelevels,Numeric=F)
  ElevLevels <- SarpGeneral::convertArrayFromSQL(QuestDef[QuestDef$code==QuestCode,]$elevlevels,Numeric=F)
  QType <- QuestDef$responsetype[QuestDef$code==QuestCode]

  #############################
  ## SINGLE CHOICE QUESTIONS
  #############################
  if (QType=="SC" | QType=="SCO"){
    
    if (transformToMinimalLine){
      
      # ## IF CHARACTERIZATION ON LINE LEVEL
      # ## *********************************
      # if (ncol(df) > 1){
      #   df[df=="dna"] <- NA
      #   df = as.data.frame(t(apply(df,1, function(x) { return(c(x[!is.na(x)],x[is.na(x)]) )} )))
      #   df <- df[,1,drop=F]
      #   names(df) <- QuestCode       
      # }
      
      if(!is.na(LineLevels[1])){
        

        ## DETERMINE RELEVANT LINES
        ## ************************
        
        if(is.null(RunCharMinRelevantSkiLine)){RunCharMinRelevantSkiLine <- getRunCharMinRelevantSkiLine(Operation=Operation)}
        
        UUIDS_Cons <- RunCharMinRelevantSkiLine$Assess_UUIDS_Cons
        UUIDS_Typ  <- RunCharMinRelevantSkiLine$Assess_UUIDS_Typ
        UUIDS_Aggr <- RunCharMinRelevantSkiLine$Assess_UUIDS_Aggr
        
        df <- RunCharAssessQuestion
        
        minLineDF <- data.frame("uuid"=c(UUIDS_Cons, UUIDS_Typ, UUIDS_Aggr), "minLine"=NA)
        minLineDF[minLineDF$uuid %in% UUIDS_Cons,]$minLine <- "c"
        minLineDF[minLineDF$uuid %in% UUIDS_Typ,]$minLine <- "t"
        minLineDF[minLineDF$uuid %in% UUIDS_Aggr,]$minLine <- "a"
        
        df <- merge(df, minLineDF, by="uuid")
        
        # CHECK_DF_1 <<- df
        
        ## TRANSFER RELEVANT RECORDS FOR MINIMAL SKI LINES TO NEW COLUMNS
        ## **************************************************************
        
        ## Version across all elevation bands
        ElevLevels <- ElevLevels[!(ElevLevels %in% "all")]
        if (!is.na(ElevLevels[1])){
          ColDest <- paste(QuestCode,ElevLevels,sep="_")
        } else {
          ColDest <- QuestCode
        }
  
        for (i in 1:length(ColDest)){
          df[, ColDest[i]] <- factor(NA, levels=QuestEnum$code, labels=QuestEnum$code, ordered=T)
        }
        
        # CHECK_DF_2 <<- df
        
        for (i in 1:nrow(df)){
          minLine <- df$minLine[i]
          if(!(is.na(minLine))){
            if (!is.na(ElevLevels[1])){
              ColSrc <- paste0(QuestCode,"_",minLine,"_", ElevLevels)
            } else {
              ColSrc <- paste(QuestCode, minLine, sep="_")
            }
            # print(ColSrc)
            # print(ColDest)
            # print(i)
            df[i,ColDest] <- df[i,ColSrc]
          }
        }
        
        
      CHECK_DF_3 <<- df
  
      
  
      # ## MAKE TABLE FOR EACH TERRAIN LEVEL IF APPLICABLE AND APPEND
      # FreqTbl <- data.frame("Answ"=as.character(QuestEnum$code),
      #                       "order"=QuestEnum$order)
      # for(i in 1:ncol(df)){
      #   a <- table(df[,i])/length(df[!is.na(df[,i]),])*100
      #   a <- as.data.frame(a)
      #   colnames(a)[1] <- "Answ"
      #   a$Answ<- as.character(a$Answ) 
      #   FreqTbl <- merge(FreqTbl, a, all.x=T, by="Answ")
      # }
      # 
      # # FreqTbl <- FreqTbl[,!(names(FreqTbl) %in% c("order"))]
      # FreqTbl$Quest <- rep(QuestCode, nrow(FreqTbl))
      # FreqTbl <- FreqTbl[order(FreqTbl$order),]
      
      
      ## Version elevation band specific reporting     
      if(!(is.na(ElevLevels[1]))){

        for(elev in 1:length(ElevLevels)){
          
          FreqTbl_Elev <- data.frame("Quest"=rep(QuestCode, length(QuestEnum$code)), 
                                     "Elev"=rep(ElevLevels[elev], length(QuestEnum$code)), 
                                     "Answ"=QuestEnum$code)
          
          ColDest <- paste(QuestCode,ElevLevels[elev],sep="_")
          a <- table(df[,ColDest], useNA = "always") / length(df[,ColDest])*100
          a <- as.data.frame(a)
          colnames(a) <- c("Answ", "Freq")
          # a$Answ <- factor(as.numeric(a$Answ), levels=QuestEnum$code, labels=QuestEnum$code, ordered=T)
          FreqTbl_Elev <- merge(FreqTbl_Elev, a, all.x=T, by="Answ")
          
          if (elev==1){
            FreqTbl <- FreqTbl_Elev
          } else {
            FreqTbl <- rbind(FreqTbl,FreqTbl_Elev )
          }
        }
        
      ## No elevation bands on the line
      } else {
        
          FreqTbl <- data.frame("Quest"=rep(QuestCode, length(QuestEnum$code)), 
                                "Elev"=rep(NA, length(QuestEnum$code)), 
                                "Answ"=QuestEnum$code)
          ColDest <- QuestCode
          a <- table(df[,ColDest], useNA = "always") / length(df[,ColDest])*100
          a <- as.data.frame(a)
          
          colnames(a) <- c("Answ", "Freq")
          # a$Answ <- factor(as.numeric(a$Answ), levels=QuestEnum$code, labels=QuestEnum$code, ordered=T)
          FreqTbl <- merge(FreqTbl, a, all.x=T, by="Answ")
        
      }
      
      ## CASE: QUESTION WITHOUT ELEV OR LINE
      } else {
        
        FreqTbl <- data.frame("Quest"=rep(QuestCode, length(QuestEnum$code)), 
                              "Elev"=rep(NA, length(QuestEnum$code)), 
                              "Answ"=QuestEnum$code)
        ColDest <- QuestCode
        a <- table(df[,ColDest], useNA = "always") / length(df[,ColDest])*100
        a <- as.data.frame(a)
  
        colnames(a) <- c("Answ", "Freq")
        # a$Answ <- factor(as.numeric(a$Answ), levels=QuestEnum$code, labels=QuestEnum$code, ordered=T)
        FreqTbl <- merge(FreqTbl, a, all.x=T, by="Answ")
        
        CHECK_DF_3 <<- RunCharAssessQuestion        
      }
    }#end if transformToMinimalLine
    
    #############################
    ## MULTIPLE CHOICE QUESTIONS
    #############################
  } else { 
    
    if (transformToMinimalLine){
      
      ## DETERMINE RELEVANT LINES
      ## ************************
      
      if(is.null(RunCharMinRelevantSkiLine)){RunCharMinRelevantSkiLine <- getRunCharMinRelevantSkiLine(Operation=Operation)}
      
      UUIDS_Cons <- RunCharMinRelevantSkiLine$Assess_UUIDS_Cons
      UUIDS_Typ  <- RunCharMinRelevantSkiLine$Assess_UUIDS_Typ
      UUIDS_Aggr <- RunCharMinRelevantSkiLine$Assess_UUIDS_Aggr
      
      df <- RunCharAssessQuestion
      
      minLineDF <- data.frame("uuid"=c(UUIDS_Cons, UUIDS_Typ, UUIDS_Aggr), "minLine"=NA)
      minLineDF[minLineDF$uuid %in% UUIDS_Cons,]$minLine <- "c"
      minLineDF[minLineDF$uuid %in% UUIDS_Typ,]$minLine <- "t"
      minLineDF[minLineDF$uuid %in% UUIDS_Aggr,]$minLine <- "a"
      
      df <- merge(df, minLineDF, by="uuid")

      ## TRANSFER RELEVANT RECORDS FOR MINIMAL SKI LINES TO NEW COLUMNS
      ## **************************************************************
      
      ## Version across all elevation bands
      ElevLevels <- ElevLevels[!(ElevLevels %in% "all")]
      if (!is.na(ElevLevels[1])){
        ColDest <- paste(QuestCode,ElevLevels,sep="_")
        ColDest <- paste0(ColDest,"_")
        ColDest_ALP <- as.vector(unlist(outer(ColDest[1],QuestEnum$code,FUN = "paste0")))
        ColDest_TL <- as.vector(unlist(outer(ColDest[2],QuestEnum$code,FUN = "paste0")))
        ColDest_BTL <- as.vector(unlist(outer(ColDest[3],QuestEnum$code,FUN = "paste0")))
        ColDest <- c(ColDest_ALP,ColDest_TL,ColDest_BTL)
      } else {
        ColDest <- paste0(QuestCode,"_")
        ColDest <- paste(QuestCode, QuestEnum$code,sep="_")
      }
      
      df[,ColDest] <- NA
      for (i in 1:nrow(df)){
        minLine <- df$minLine[i]
        if(!(is.na(minLine))){
          if (!is.na(ElevLevels[1])){
            ColSrc <- paste0(QuestCode,"_",minLine,"_", ElevLevels, "_")
            ColSrc_ALP <- as.vector(unlist(outer(ColSrc[1],QuestEnum$code,FUN = "paste0")))
            ColSrc_TL <- as.vector(unlist(outer(ColSrc[2],QuestEnum$code,FUN = "paste0")))
            ColSrc_BTL <- as.vector(unlist(outer(ColSrc[3],QuestEnum$code,FUN = "paste0")))
            ColSrc <- c(ColSrc_ALP,ColSrc_TL,ColSrc_BTL) 
          } else {
            ColSrc <- paste(QuestCode, minLine, sep="_")
            ColSrc <- paste(ColSrc, QuestEnum$code,sep="_")
          }
          df[i,ColDest] <- df[i,ColSrc]
        }
      }

      FreqTbl <- data.frame("Answ"=names(df[,ColDest]))
      FreqTbl$Freq <- colSums(df[,ColDest], na.rm=T)/nrow(df[,ColDest]) *100
      FreqTbl$Quest <- QuestCode
      
      ## Version elevation band specific reporting     
      if(!(is.na(ElevLevels[1]))){
        
        for(elev in 1:length(ElevLevels)){
          
          FreqTbl_Elev <- data.frame("Quest"=rep(QuestCode, length(QuestEnum$code)), 
                                     "Elev"=rep(ElevLevels[elev], length(QuestEnum$code)), 
                                     "Answ"=QuestEnum$code, 
                                     "Freq"=NA)

          ColDest <- paste(QuestCode,ElevLevels[elev],sep="_")
          ColDest <- paste0(ColDest,"_")
          ColDest <- as.vector(unlist(outer(ColDest,QuestEnum$code,FUN = "paste0")))
          
          FreqTbl_Elev$Freq <- colSums(df[,ColDest], na.rm=T)/nrow(df[,ColDest]) *100
          if (elev==1){
            FreqTbl <- FreqTbl_Elev
          } else {
            FreqTbl <- rbind(FreqTbl,FreqTbl_Elev )
          }
        }
      } else {

          FreqTbl <- data.frame("Quest"=rep(QuestCode, length(QuestEnum$code)), 
                                "Elev"=rep(NA, length(QuestEnum$code)), 
                                "Answ"=QuestEnum$code, 
                                "Freq"=NA)
          
          ColDest <- paste0(QuestCode,"_")
          ColDest <- paste(QuestCode, QuestEnum$code,sep="_")
          
          FreqTbl$Freq <- colSums(df[,ColDest], na.rm=T)/nrow(df[,ColDest]) *100
          
      }
      
    } else {
      
      ## COUNT 'TRUE' FOR ALL QUESTIONS
      FreqTbl <- colSums(df)/nrow(df)*100
      FreqTbl <- as.data.frame(FreqTbl)
      names(FreqTbl) <- "Freq"
      FreqTbl$Answ <- names(df)
      
      ## CONSTRUCT ANSWER CODES AND QUESTION NAMES
      a <- as.data.frame(lapply(strsplit(FreqTbl$Answ, ''), function(x) which(x == '_')))
      names(a) <- FreqTbl$Answ
      FreqTbl$Quest <- NA
      for (i in 1:ncol(a)){
        FreqTbl$Answ[i] <- substr(names(a)[i], a[nrow(a),i]+1, nchar(names(a)[i]))
        FreqTbl$Quest[i] <- substr(names(a)[i], 1, a[nrow(a),i]-1)
      }
      row.names(FreqTbl) <- 1:nrow(FreqTbl)      
    }

  }
  
  ## RETURN TABLE
  ## ***********
  
  # FreqTbl <<- FreqTbl
  QuestEnum$order <- 1:nrow(QuestEnum)
  FreqTbl <- merge(FreqTbl, QuestEnum[,c("code","order")], by.x="Answ", by.y="code")
  FreqTbl <- FreqTbl[order(FreqTbl$order),]
  FreqTbl <- FreqTbl[,!(names(FreqTbl) %in% "order"),drop=F]
  
  if ("Elev" %in% names(FreqTbl)){
    output <- rearrangeDFColumnsByName(FreqTbl, c("Quest", "Elev","Answ", "Freq"))
  } else {
    output <- rearrangeDFColumnsByName(FreqTbl, c("Quest", "Answ", "Freq"))
  }
  rm(FreqTbl)
  return(output)
  
}## END FUNCTION