#' Get run character assessments from the online survey
#'
#' Get run character assessments from the online survey at avterrain.avalancheresearch.ca
#' @param Operation Name of operation
#' @param Verbose Switch for printing of query.
#' 
#' @examples
#' require(SarpGPSTools)
#' require(SarpGPSToolsPrivate)
#' 
#' Oper <- "CMHGL"
#' 
#' Survey <- getRunCharAssessmentsSurvey(Oper)
#' 
#' @export


getRunCharAssessmentsSurvey <- function(Oper, Verbose=F) {

  ## Getting data
  ## ************
  ## Assessments
  Query <- paste0("SELECT * FROM export_r_assessments WHERE oper_abbrev='", Oper, "' and runs_show_flag=1")
  Assess <- getRecordsFromQueryTerrainSurvey(Query, Verbose = Verbose)
  
  ## Meta data for runs
  Query <- paste0("SELECT * FROM export_r_runsetup WHERE oper_abbrev='", Oper, "'")
  RunSetup <- getRecordsFromQueryTerrainSurvey(Query, Verbose = Verbose)
  
  ## User information
  Query <- paste0("SELECT * FROM export_r_userinfo WHERE oper_abbrev='", Oper, "'")
  UserInfo <- getRecordsFromQueryTerrainSurvey(Query, Verbose = Verbose)
  
  ## Filtering
  ## *********
  ## Eliminate test runs
  TestRuns <- grep("test", tolower(Assess$loccatskirunslines_name))
  if (length(TestRuns) > 0) {
    Assess <- Assess[-TestRuns,]
  }
  rm(TestRuns)
  
  ## Eliminate guides that did not complete any run assessments
  GuidesWithAssess <- unique(Assess$user_id)
  UserInfo <- UserInfo[UserInfo$user_id %in% GuidesWithAssess,]
  rm(GuidesWithAssess)
  
  ## Formatting
  ## **********
  ## Assessments
  
  ## Familiarity
  Assess$familiarity <- ordered(Assess$familiarity, levels = c("none", "low", "mod", "high"))
  
  ## Access
  Assess$access_gen_feel_1 <- ordered(Assess$access_gen_feel_1, levels = c("perfect", "lineup", "often", "always"))
  Assess$access_gen_feel_2 <- ordered(Assess$access_gen_feel_2, levels = c("perfect", "lineup", "often", "always"))
  Assess$access_gen_feel_3 <- ordered(Assess$access_gen_feel_3, levels = c("perfect", "lineup", "often", "always"))
  
  Assess$access_best_land_1 <- ordered(Assess$access_best_land_1, levels = c("minimal", "reasonable", "well"))
  Assess$access_best_land_2 <- ordered(Assess$access_best_land_2, levels = c("minimal", "reasonable", "well"))
  Assess$access_best_land_3 <- ordered(Assess$access_best_land_3, levels = c("minimal", "reasonable", "well"))
  
  Assess$access_land_feat_1 <- ordered(Assess$access_land_feat_1, levels = c("no", "yes"))
  Assess$access_land_feat_2 <- ordered(Assess$access_land_feat_2, levels = c("no", "yes"))
  Assess$access_land_feat_3 <- ordered(Assess$access_land_feat_3, levels = c("no", "yes"))
  
  Assess$access_land_feat_1_lowweight <- ordered(Assess$access_land_feat_1_lowweight, levels = c(0, 1), labels = c("no", "yes"))
  Assess$access_land_feat_2_lowweight <- ordered(Assess$access_land_feat_2_lowweight, levels = c(0, 1), labels = c("no", "yes"))
  Assess$access_land_feat_3_lowweight <- ordered(Assess$access_land_feat_3_lowweight, levels = c(0, 1), labels = c("no", "yes"))
  
  Assess$access_land_feat_1_winds <- ordered(Assess$access_land_feat_1_winds, levels = c(0, 1), labels = c("no", "yes"))
  Assess$access_land_feat_2_winds <- ordered(Assess$access_land_feat_2_winds, levels = c(0, 1), labels = c("no", "yes"))
  Assess$access_land_feat_3_winds <- ordered(Assess$access_land_feat_3_winds, levels = c(0, 1), labels = c("no", "yes"))
  
  Assess$access_land_feat_1_direction <- ordered(Assess$access_land_feat_1_direction, levels = c(0, 1), labels = c("no", "yes"))
  Assess$access_land_feat_2_direction <- ordered(Assess$access_land_feat_2_direction, levels = c(0, 1), labels = c("no", "yes"))
  Assess$access_land_feat_3_direction <- ordered(Assess$access_land_feat_3_direction, levels = c(0, 1), labels = c("no", "yes"))
  
  Assess$access_land_feat_1_other <- ordered(Assess$access_land_feat_1_other, levels = c(0, 1), labels = c("no", "yes"))
  Assess$access_land_feat_2_other <- ordered(Assess$access_land_feat_2_other, levels = c(0, 1), labels = c("no", "yes"))
  Assess$access_land_feat_3_other <- ordered(Assess$access_land_feat_3_other, levels = c(0, 1), labels = c("no", "yes"))
  
  Assess$access_pickup_feat_1 <- ordered(Assess$access_pickup_feat_1, levels = c("no", "yes"))
  Assess$access_pickup_feat_2 <- ordered(Assess$access_pickup_feat_2, levels = c("no", "yes"))
  Assess$access_pickup_feat_3 <- ordered(Assess$access_pickup_feat_3, levels = c("no", "yes"))
  
  Assess$access_pickup_feat_1_lowweight <- ordered(Assess$access_pickup_feat_1_lowweight, levels = c(0, 1), labels = c("no", "yes"))
  Assess$access_pickup_feat_2_lowweight <- ordered(Assess$access_pickup_feat_2_lowweight, levels = c(0, 1), labels = c("no", "yes"))
  Assess$access_pickup_feat_3_lowweight <- ordered(Assess$access_pickup_feat_3_lowweight, levels = c(0, 1), labels = c("no", "yes"))
  
  Assess$access_pickup_feat_1_minimal <- ordered(Assess$access_pickup_feat_1_minimal, levels = c(0, 1), labels = c("no", "yes"))
  Assess$access_pickup_feat_2_minimal <- ordered(Assess$access_pickup_feat_2_minimal, levels = c(0, 1), labels = c("no", "yes"))
  Assess$access_pickup_feat_3_minimal <- ordered(Assess$access_pickup_feat_3_minimal, levels = c(0, 1), labels = c("no", "yes"))
  
  Assess$access_pickup_feat_1_fog <- ordered(Assess$access_pickup_feat_1_fog, levels = c(0, 1), labels = c("no", "yes"))
  Assess$access_pickup_feat_2_fog <- ordered(Assess$access_pickup_feat_2_fog, levels = c(0, 1), labels = c("no", "yes"))
  Assess$access_pickup_feat_3_fog <- ordered(Assess$access_pickup_feat_3_fog, levels = c(0, 1), labels = c("no", "yes"))
  
  Assess$access_pickup_feat_1_blowsnow <- ordered(Assess$access_pickup_feat_1_blowsnow, levels = c(0, 1), labels = c("no", "yes"))
  Assess$access_pickup_feat_2_blowsnow <- ordered(Assess$access_pickup_feat_2_blowsnow, levels = c(0, 1), labels = c("no", "yes"))
  Assess$access_pickup_feat_3_blowsnow <- ordered(Assess$access_pickup_feat_3_blowsnow, levels = c(0, 1), labels = c("no", "yes"))
  
  Assess$access_pickup_feat_1_regularoh <- ordered(Assess$access_pickup_feat_1_regularoh, levels = c(0, 1), labels = c("no", "yes"))
  Assess$access_pickup_feat_2_regularoh <- ordered(Assess$access_pickup_feat_2_regularoh, levels = c(0, 1), labels = c("no", "yes"))
  Assess$access_pickup_feat_3_regularoh <- ordered(Assess$access_pickup_feat_3_regularoh, levels = c(0, 1), labels = c("no", "yes"))
  
  Assess$access_pickup_feat_1_largeoh <- ordered(Assess$access_pickup_feat_1_largeoh, levels = c(0, 1), labels = c("no", "yes"))
  Assess$access_pickup_feat_2_largeoh <- ordered(Assess$access_pickup_feat_2_largeoh, levels = c(0, 1), labels = c("no", "yes"))
  Assess$access_pickup_feat_3_largeoh <- ordered(Assess$access_pickup_feat_3_largeoh, levels = c(0, 1), labels = c("no", "yes"))
  
  Assess$access_pickup_feat_1_triggeroh <- ordered(Assess$access_pickup_feat_1_triggeroh, levels = c(0, 1), labels = c("no", "yes"))
  Assess$access_pickup_feat_2_triggeroh <- ordered(Assess$access_pickup_feat_2_triggeroh, levels = c(0, 1), labels = c("no", "yes"))
  Assess$access_pickup_feat_3_triggeroh <- ordered(Assess$access_pickup_feat_3_triggeroh, levels = c(0, 1), labels = c("no", "yes"))
  
  Assess$access_pickup_feat_1_other <- ordered(Assess$access_pickup_feat_1_other, levels = c(0, 1), labels = c("no", "yes"))
  Assess$access_pickup_feat_2_other <- ordered(Assess$access_pickup_feat_2_other, levels = c(0, 1), labels = c("no", "yes"))
  Assess$access_pickup_feat_3_other <- ordered(Assess$access_pickup_feat_3_other, levels = c(0, 1), labels = c("no", "yes"))
  
  Assess$access_incident_1 <- ordered(Assess$access_incident_1, levels = c("no", "aware", "personal"))
  Assess$access_incident_2 <- ordered(Assess$access_incident_2, levels = c("no", "aware", "personal"))
  Assess$access_incident_3 <- ordered(Assess$access_incident_3, levels = c("no", "aware", "personal"))
  
  ## Ski experience
  Assess$ski_terrain_1_alp_glac <- ordered(Assess$ski_terrain_1_alp_glac, levels = c(0, 1), labels = c("no", "yes"))
  Assess$ski_terrain_2_alp_glac <- ordered(Assess$ski_terrain_2_alp_glac, levels = c(0, 1), labels = c("no", "yes"))
  Assess$ski_terrain_3_alp_glac <- ordered(Assess$ski_terrain_3_alp_glac, levels = c(0, 1), labels = c("no", "yes"))
  
  Assess$ski_terrain_1_alp_nonglac <- ordered(Assess$ski_terrain_1_alp_nonglac, levels = c(0, 1), labels = c("no", "yes"))
  Assess$ski_terrain_2_alp_nonglac <- ordered(Assess$ski_terrain_2_alp_nonglac, levels = c(0, 1), labels = c("no", "yes"))
  Assess$ski_terrain_3_alp_nonglac <- ordered(Assess$ski_terrain_3_alp_nonglac, levels = c(0, 1), labels = c("no", "yes"))
  
  Assess$ski_terrain_1_alp_extremealp <- ordered(Assess$ski_terrain_1_alp_extremealp, levels = c(0, 1), labels = c("no", "yes"))
  Assess$ski_terrain_2_alp_extremealp <- ordered(Assess$ski_terrain_2_alp_extremealp, levels = c(0, 1), labels = c("no", "yes"))
  Assess$ski_terrain_3_alp_extremealp <- ordered(Assess$ski_terrain_3_alp_extremealp, levels = c(0, 1), labels = c("no", "yes"))
  
  Assess$ski_terrain_1_alp_planar <- ordered(Assess$ski_terrain_1_alp_planar, levels = c(0, 1), labels = c("no", "yes"))
  Assess$ski_terrain_2_alp_planar <- ordered(Assess$ski_terrain_2_alp_planar, levels = c(0, 1), labels = c("no", "yes"))
  Assess$ski_terrain_3_alp_planar <- ordered(Assess$ski_terrain_3_alp_planar, levels = c(0, 1), labels = c("no", "yes"))
  
  Assess$ski_terrain_1_alp_featured <- ordered(Assess$ski_terrain_1_alp_featured, levels = c(0, 1), labels = c("no", "yes"))
  Assess$ski_terrain_2_alp_featured <- ordered(Assess$ski_terrain_2_alp_featured, levels = c(0, 1), labels = c("no", "yes"))
  Assess$ski_terrain_3_alp_featured <- ordered(Assess$ski_terrain_3_alp_featured, levels = c(0, 1), labels = c("no", "yes"))
  
  Assess$ski_terrain_1_alp_avfan <- ordered(Assess$ski_terrain_1_alp_avfan, levels = c(0, 1), labels = c("no", "yes"))
  Assess$ski_terrain_2_alp_avfan <- ordered(Assess$ski_terrain_2_alp_avfan, levels = c(0, 1), labels = c("no", "yes"))
  Assess$ski_terrain_3_alp_avfan <- ordered(Assess$ski_terrain_3_alp_avfan, levels = c(0, 1), labels = c("no", "yes"))
  
  Assess$ski_terrain_1_alp_ridgetop <- ordered(Assess$ski_terrain_1_alp_ridgetop, levels = c(0, 1), labels = c("no", "yes"))
  Assess$ski_terrain_2_alp_ridgetop <- ordered(Assess$ski_terrain_2_alp_ridgetop, levels = c(0, 1), labels = c("no", "yes"))
  Assess$ski_terrain_3_alp_ridgetop <- ordered(Assess$ski_terrain_3_alp_ridgetop, levels = c(0, 1), labels = c("no", "yes"))
  
  Assess$ski_terrain_1_alp_moraine <- ordered(Assess$ski_terrain_1_alp_moraine, levels = c(0, 1), labels = c("no", "yes"))
  Assess$ski_terrain_2_alp_moraine <- ordered(Assess$ski_terrain_2_alp_moraine, levels = c(0, 1), labels = c("no", "yes"))
  Assess$ski_terrain_3_alp_moraine <- ordered(Assess$ski_terrain_3_alp_moraine, levels = c(0, 1), labels = c("no", "yes"))
  
  Assess$ski_terrain_1_alp_other <- ordered(Assess$ski_terrain_1_alp_other, levels = c(0, 1), labels = c("no", "yes"))
  Assess$ski_terrain_2_alp_other <- ordered(Assess$ski_terrain_2_alp_other, levels = c(0, 1), labels = c("no", "yes"))
  Assess$ski_terrain_3_alp_other <- ordered(Assess$ski_terrain_3_alp_other, levels = c(0, 1), labels = c("no", "yes"))
  
  Assess$ski_terrain_1_tl_open <- ordered(Assess$ski_terrain_1_tl_open, levels = c(0, 1), labels = c("no", "yes"))
  Assess$ski_terrain_2_tl_open <- ordered(Assess$ski_terrain_2_tl_open, levels = c(0, 1), labels = c("no", "yes"))
  Assess$ski_terrain_3_tl_open <- ordered(Assess$ski_terrain_3_tl_open, levels = c(0, 1), labels = c("no", "yes"))
  
  Assess$ski_terrain_1_tl_glades <- ordered(Assess$ski_terrain_1_tl_glades, levels = c(0, 1), labels = c("no", "yes"))
  Assess$ski_terrain_2_tl_glades <- ordered(Assess$ski_terrain_2_tl_glades, levels = c(0, 1), labels = c("no", "yes"))
  Assess$ski_terrain_3_tl_glades <- ordered(Assess$ski_terrain_3_tl_glades, levels = c(0, 1), labels = c("no", "yes"))
  
  Assess$ski_terrain_1_tl_planar <- ordered(Assess$ski_terrain_1_tl_planar, levels = c(0, 1), labels = c("no", "yes"))
  Assess$ski_terrain_2_tl_planar <- ordered(Assess$ski_terrain_2_tl_planar, levels = c(0, 1), labels = c("no", "yes"))
  Assess$ski_terrain_3_tl_planar <- ordered(Assess$ski_terrain_3_tl_planar, levels = c(0, 1), labels = c("no", "yes"))
  
  Assess$ski_terrain_1_tl_featured <- ordered(Assess$ski_terrain_1_tl_featured, levels = c(0, 1), labels = c("no", "yes"))
  Assess$ski_terrain_2_tl_featured <- ordered(Assess$ski_terrain_2_tl_featured, levels = c(0, 1), labels = c("no", "yes"))
  Assess$ski_terrain_3_tl_featured <- ordered(Assess$ski_terrain_3_tl_featured, levels = c(0, 1), labels = c("no", "yes"))
  
  Assess$ski_terrain_1_tl_likealp <- ordered(Assess$ski_terrain_1_tl_alplike, levels = c(0, 1), labels = c("no", "yes"))
  Assess$ski_terrain_2_tl_likealp <- ordered(Assess$ski_terrain_2_tl_alplike, levels = c(0, 1), labels = c("no", "yes"))
  Assess$ski_terrain_3_tl_likealp <- ordered(Assess$ski_terrain_3_tl_alplike, levels = c(0, 1), labels = c("no", "yes"))
  
  Assess$ski_terrain_1_tl_burn <- ordered(Assess$ski_terrain_1_tl_burn, levels = c(0, 1), labels = c("no", "yes"))
  Assess$ski_terrain_2_tl_burn <- ordered(Assess$ski_terrain_2_tl_burn, levels = c(0, 1), labels = c("no", "yes"))
  Assess$ski_terrain_3_tl_burn <- ordered(Assess$ski_terrain_3_tl_burn, levels = c(0, 1), labels = c("no", "yes"))
  
  Assess$ski_terrain_1_tl_avfan <- ordered(Assess$ski_terrain_1_tl_avfan, levels = c(0, 1), labels = c("no", "yes"))
  Assess$ski_terrain_2_tl_avfan <- ordered(Assess$ski_terrain_2_tl_avfan, levels = c(0, 1), labels = c("no", "yes"))
  Assess$ski_terrain_3_tl_avfan <- ordered(Assess$ski_terrain_3_tl_avfan, levels = c(0, 1), labels = c("no", "yes"))
  
  Assess$ski_terrain_1_tl_ridgetop <- ordered(Assess$ski_terrain_1_tl_ridgetop, levels = c(0, 1), labels = c("no", "yes"))
  Assess$ski_terrain_2_tl_ridgetop <- ordered(Assess$ski_terrain_2_tl_ridgetop, levels = c(0, 1), labels = c("no", "yes"))
  Assess$ski_terrain_3_tl_ridgetop <- ordered(Assess$ski_terrain_3_tl_ridgetop, levels = c(0, 1), labels = c("no", "yes"))
  
  Assess$ski_terrain_1_tl_moraine <- ordered(Assess$ski_terrain_1_tl_moraine, levels = c(0, 1), labels = c("no", "yes"))
  Assess$ski_terrain_2_tl_moraine <- ordered(Assess$ski_terrain_2_tl_moraine, levels = c(0, 1), labels = c("no", "yes"))
  Assess$ski_terrain_3_tl_moraine <- ordered(Assess$ski_terrain_3_tl_moraine, levels = c(0, 1), labels = c("no", "yes"))
  
  Assess$ski_terrain_1_tl_rollsattl <- ordered(Assess$ski_terrain_1_tl_tlrolls, levels = c(0, 1), labels = c("no", "yes"))
  Assess$ski_terrain_2_tl_rollsattl <- ordered(Assess$ski_terrain_2_tl_tlrolls, levels = c(0, 1), labels = c("no", "yes"))
  Assess$ski_terrain_3_tl_rollsattl <- ordered(Assess$ski_terrain_3_tl_tlrolls, levels = c(0, 1), labels = c("no", "yes"))
  
  Assess$ski_terrain_1_tl_open <- ordered(Assess$ski_terrain_1_tl_open, levels = c(0, 1), labels = c("no", "yes"))
  Assess$ski_terrain_2_tl_open <- ordered(Assess$ski_terrain_2_tl_open, levels = c(0, 1), labels = c("no", "yes"))
  Assess$ski_terrain_3_tl_open <- ordered(Assess$ski_terrain_3_tl_open, levels = c(0, 1), labels = c("no", "yes"))
  
  Assess$ski_terrain_1_tl_other <- ordered(Assess$ski_terrain_1_tl_other, levels = c(0, 1), labels = c("no", "yes"))
  Assess$ski_terrain_2_tl_other <- ordered(Assess$ski_terrain_2_tl_other, levels = c(0, 1), labels = c("no", "yes"))
  Assess$ski_terrain_3_tl_other <- ordered(Assess$ski_terrain_3_tl_other, levels = c(0, 1), labels = c("no", "yes"))
  
  Assess$ski_terrain_1_btl_open <- ordered(Assess$ski_terrain_1_btl_open, levels = c(0, 1), labels = c("no", "yes"))
  Assess$ski_terrain_2_btl_open <- ordered(Assess$ski_terrain_2_btl_open, levels = c(0, 1), labels = c("no", "yes"))
  Assess$ski_terrain_3_btl_open <- ordered(Assess$ski_terrain_3_btl_open, levels = c(0, 1), labels = c("no", "yes"))
  
  Assess$ski_terrain_1_btl_glades <- ordered(Assess$ski_terrain_1_btl_glades, levels = c(0, 1), labels = c("no", "yes"))
  Assess$ski_terrain_2_btl_glades <- ordered(Assess$ski_terrain_2_btl_glades, levels = c(0, 1), labels = c("no", "yes"))
  Assess$ski_terrain_3_btl_glades <- ordered(Assess$ski_terrain_3_btl_glades, levels = c(0, 1), labels = c("no", "yes"))
  
  Assess$ski_terrain_1_btl_snowforest <- ordered(Assess$ski_terrain_1_btl_snowforest, levels = c(0, 1), labels = c("no", "yes"))
  Assess$ski_terrain_2_btl_snowforest <- ordered(Assess$ski_terrain_2_btl_snowforest, levels = c(0, 1), labels = c("no", "yes"))
  Assess$ski_terrain_3_btl_snowforest <- ordered(Assess$ski_terrain_3_btl_snowforest, levels = c(0, 1), labels = c("no", "yes"))
  
  Assess$ski_terrain_1_btl_cut <- ordered(Assess$ski_terrain_1_btl_cut, levels = c(0, 1), labels = c("no", "yes"))
  Assess$ski_terrain_2_btl_cut <- ordered(Assess$ski_terrain_2_btl_cut, levels = c(0, 1), labels = c("no", "yes"))
  Assess$ski_terrain_3_btl_cut <- ordered(Assess$ski_terrain_3_btl_cut, levels = c(0, 1), labels = c("no", "yes"))
  
  Assess$ski_terrain_1_btl_avpath <- ordered(Assess$ski_terrain_1_btl_avpath, levels = c(0, 1), labels = c("no", "yes"))
  Assess$ski_terrain_2_btl_avpath <- ordered(Assess$ski_terrain_2_btl_avpath, levels = c(0, 1), labels = c("no", "yes"))
  Assess$ski_terrain_3_btl_avpath <- ordered(Assess$ski_terrain_3_btl_avpath, levels = c(0, 1), labels = c("no", "yes"))
  
  Assess$ski_terrain_1_btl_regen <- ordered(Assess$ski_terrain_1_btl_regen, levels = c(0, 1), labels = c("no", "yes"))
  Assess$ski_terrain_2_btl_regen <- ordered(Assess$ski_terrain_2_btl_regen, levels = c(0, 1), labels = c("no", "yes"))
  Assess$ski_terrain_3_btl_regen <- ordered(Assess$ski_terrain_3_btl_regen, levels = c(0, 1), labels = c("no", "yes"))
  
  Assess$ski_terrain_1_btl_burn <- ordered(Assess$ski_terrain_1_btl_burn, levels = c(0, 1), labels = c("no", "yes"))
  Assess$ski_terrain_2_btl_burn <- ordered(Assess$ski_terrain_2_btl_burn, levels = c(0, 1), labels = c("no", "yes"))
  Assess$ski_terrain_3_btl_burn <- ordered(Assess$ski_terrain_3_btl_burn, levels = c(0, 1), labels = c("no", "yes"))
  
  Assess$ski_terrain_1_btl_dense <- ordered(Assess$ski_terrain_1_btl_dense, levels = c(0, 1), labels = c("no", "yes"))
  Assess$ski_terrain_2_btl_dense <- ordered(Assess$ski_terrain_2_btl_dense, levels = c(0, 1), labels = c("no", "yes"))
  Assess$ski_terrain_3_btl_dense <- ordered(Assess$ski_terrain_3_btl_dense, levels = c(0, 1), labels = c("no", "yes"))
  
  Assess$ski_terrain_1_btl_planar <- ordered(Assess$ski_terrain_1_btl_planar, levels = c(0, 1), labels = c("no", "yes"))
  Assess$ski_terrain_2_btl_planar <- ordered(Assess$ski_terrain_2_btl_planar, levels = c(0, 1), labels = c("no", "yes"))
  Assess$ski_terrain_3_btl_planar <- ordered(Assess$ski_terrain_3_btl_planar, levels = c(0, 1), labels = c("no", "yes"))
  
  Assess$ski_terrain_1_btl_featured <- ordered(Assess$ski_terrain_1_btl_featured, levels = c(0, 1), labels = c("no", "yes"))
  Assess$ski_terrain_2_btl_featured <- ordered(Assess$ski_terrain_2_btl_featured, levels = c(0, 1), labels = c("no", "yes"))
  Assess$ski_terrain_3_btl_featured <- ordered(Assess$ski_terrain_3_btl_featured, levels = c(0, 1), labels = c("no", "yes"))
  
  Assess$ski_terrain_1_btl_avfan <- ordered(Assess$ski_terrain_1_btl_avfan, levels = c(0, 1), labels = c("no", "yes"))
  Assess$ski_terrain_2_btl_avfan <- ordered(Assess$ski_terrain_2_btl_avfan, levels = c(0, 1), labels = c("no", "yes"))
  Assess$ski_terrain_3_btl_avfan <- ordered(Assess$ski_terrain_3_btl_avfan, levels = c(0, 1), labels = c("no", "yes"))
  
  Assess$ski_terrain_1_btl_moraine <- ordered(Assess$ski_terrain_1_btl_moraine, levels = c(0, 1), labels = c("no", "yes"))
  Assess$ski_terrain_2_btl_moraine <- ordered(Assess$ski_terrain_2_btl_moraine, levels = c(0, 1), labels = c("no", "yes"))
  Assess$ski_terrain_3_btl_moraine <- ordered(Assess$ski_terrain_3_btl_moraine, levels = c(0, 1), labels = c("no", "yes"))
  
  Assess$ski_terrain_1_btl_other <- ordered(Assess$ski_terrain_1_btl_other, levels = c(0, 1), labels = c("no", "yes"))
  Assess$ski_terrain_2_btl_other <- ordered(Assess$ski_terrain_2_btl_other, levels = c(0, 1), labels = c("no", "yes"))
  Assess$ski_terrain_3_btl_other <- ordered(Assess$ski_terrain_3_btl_other, levels = c(0, 1), labels = c("no", "yes"))
  
  Assess$ski_spec_1 <- ordered(Assess$ski_spec_1, levels = c("no", "yes"))
  Assess$ski_spec_2 <- ordered(Assess$ski_spec_2, levels = c("no", "yes"))
  Assess$ski_spec_3 <- ordered(Assess$ski_spec_3, levels = c("no", "yes"))
  
  Assess$ski_spec_1_line_scenery <- ordered(Assess$ski_spec_1_scenery, levels = c(0, 1), labels = c("no", "yes"))
  Assess$ski_spec_2_line_scenery <- ordered(Assess$ski_spec_2_scenery, levels = c(0, 1), labels = c("no", "yes"))
  Assess$ski_spec_3_line_scenery <- ordered(Assess$ski_spec_3_scenery, levels = c(0, 1), labels = c("no", "yes"))
  Assess <- deleteDFColumnsByName(Assess, c("ski_spec_1_scenery", "ski_spec_2_scenery", "ski_spec_3_scenery"))
  
  Assess$ski_spec_1_line_vertical <- ordered(Assess$ski_spec_1_vertical, levels = c(0, 1), labels = c("no", "yes"))
  Assess$ski_spec_2_line_vertical <- ordered(Assess$ski_spec_2_vertical, levels = c(0, 1), labels = c("no", "yes"))
  Assess$ski_spec_3_line_vertical <- ordered(Assess$ski_spec_3_vertical, levels = c(0, 1), labels = c("no", "yes"))
  Assess <- deleteDFColumnsByName(Assess, c("ski_spec_1_vertical", "ski_spec_2_vertical", "ski_spec_3_vertical"))
  
  Assess$ski_spec_1_line_other <- ordered(Assess$ski_spec_1_other, levels = c(0, 1), labels = c("no", "yes"))
  Assess$ski_spec_2_line_other <- ordered(Assess$ski_spec_2_other, levels = c(0, 1), labels = c("no", "yes"))
  Assess$ski_spec_3_line_other <- ordered(Assess$ski_spec_3_other, levels = c(0, 1), labels = c("no", "yes"))
  Assess <- deleteDFColumnsByName(Assess, c("ski_spec_1_other", "ski_spec_2_other", "ski_spec_3_other"))
  
  Assess$ski_spec_1_line_othertext <- Assess$ski_spec_1_othertext
  Assess$ski_spec_2_line_othertext <- Assess$ski_spec_2_othertext
  Assess$ski_spec_3_line_othertext <- Assess$ski_spec_3_othertext
  Assess <- deleteDFColumnsByName(Assess, c("ski_spec_1_othertext", "ski_spec_2_othertext", "ski_spec_3_othertext"))
  
  Assess$ski_spec_1_alp_corn <- ordered(Assess$ski_spec_1_alp_corn, levels = c(0, 1), labels = c("no", "yes"))
  Assess$ski_spec_2_alp_corn <- ordered(Assess$ski_spec_2_alp_corn, levels = c(0, 1), labels = c("no", "yes"))
  Assess$ski_spec_3_alp_corn <- ordered(Assess$ski_spec_3_alp_corn, levels = c(0, 1), labels = c("no", "yes"))
  
  Assess$ski_spec_1_alp_pillows <- ordered(Assess$ski_spec_1_alp_pillows, levels = c(0, 1), labels = c("no", "yes"))
  Assess$ski_spec_2_alp_pillows <- ordered(Assess$ski_spec_2_alp_pillows, levels = c(0, 1), labels = c("no", "yes"))
  Assess$ski_spec_3_alp_pillows <- ordered(Assess$ski_spec_3_alp_pillows, levels = c(0, 1), labels = c("no", "yes"))
  
  Assess$ski_spec_1_alp_fallline <- ordered(Assess$ski_spec_1_alp_fallline, levels = c(0, 1), labels = c("no", "yes"))
  Assess$ski_spec_2_alp_fallline <- ordered(Assess$ski_spec_2_alp_fallline, levels = c(0, 1), labels = c("no", "yes"))
  Assess$ski_spec_3_alp_fallline <- ordered(Assess$ski_spec_3_alp_fallline, levels = c(0, 1), labels = c("no", "yes"))
  
  Assess$ski_spec_1_alp_other <- ordered(Assess$ski_spec_1_alp_other, levels = c(0, 1), labels = c("no", "yes"))
  Assess$ski_spec_2_alp_other <- ordered(Assess$ski_spec_2_alp_other, levels = c(0, 1), labels = c("no", "yes"))
  Assess$ski_spec_3_alp_other <- ordered(Assess$ski_spec_3_alp_other, levels = c(0, 1), labels = c("no", "yes"))
  
  Assess$ski_spec_1_tl_deep <- ordered(Assess$ski_spec_1_tl_deep, levels = c(0, 1), labels = c("no", "yes"))
  Assess$ski_spec_2_tl_deep <- ordered(Assess$ski_spec_2_tl_deep, levels = c(0, 1), labels = c("no", "yes"))
  Assess$ski_spec_3_tl_deep <- ordered(Assess$ski_spec_3_tl_deep, levels = c(0, 1), labels = c("no", "yes"))
  
  Assess$ski_spec_1_tl_corn <- ordered(Assess$ski_spec_1_tl_corn, levels = c(0, 1), labels = c("no", "yes"))
  Assess$ski_spec_2_tl_corn <- ordered(Assess$ski_spec_2_tl_corn, levels = c(0, 1), labels = c("no", "yes"))
  Assess$ski_spec_3_tl_corn <- ordered(Assess$ski_spec_3_tl_corn, levels = c(0, 1), labels = c("no", "yes"))
  
  Assess$ski_spec_1_tl_pillows <- ordered(Assess$ski_spec_1_tl_pillows, levels = c(0, 1), labels = c("no", "yes"))
  Assess$ski_spec_2_tl_pillows <- ordered(Assess$ski_spec_2_tl_pillows, levels = c(0, 1), labels = c("no", "yes"))
  Assess$ski_spec_3_tl_pillows <- ordered(Assess$ski_spec_3_tl_pillows, levels = c(0, 1), labels = c("no", "yes"))
  
  Assess$ski_spec_1_tl_fallline <- ordered(Assess$ski_spec_1_tl_fallline, levels = c(0, 1), labels = c("no", "yes"))
  Assess$ski_spec_2_tl_fallline <- ordered(Assess$ski_spec_2_tl_fallline, levels = c(0, 1), labels = c("no", "yes"))
  Assess$ski_spec_3_tl_fallline <- ordered(Assess$ski_spec_3_tl_fallline, levels = c(0, 1), labels = c("no", "yes"))
  
  Assess$ski_spec_1_tl_other <- ordered(Assess$ski_spec_1_tl_other, levels = c(0, 1), labels = c("no", "yes"))
  Assess$ski_spec_2_tl_other <- ordered(Assess$ski_spec_2_tl_other, levels = c(0, 1), labels = c("no", "yes"))
  Assess$ski_spec_3_tl_other <- ordered(Assess$ski_spec_3_tl_other, levels = c(0, 1), labels = c("no", "yes"))
  
  Assess$ski_spec_1_btl_deep <- ordered(Assess$ski_spec_1_btl_deep, levels = c(0, 1), labels = c("no", "yes"))
  Assess$ski_spec_2_btl_deep <- ordered(Assess$ski_spec_2_btl_deep, levels = c(0, 1), labels = c("no", "yes"))
  Assess$ski_spec_3_btl_deep <- ordered(Assess$ski_spec_3_btl_deep, levels = c(0, 1), labels = c("no", "yes"))
  
  Assess$ski_spec_1_btl_corn <- ordered(Assess$ski_spec_1_btl_corn, levels = c(0, 1), labels = c("no", "yes"))
  Assess$ski_spec_2_btl_corn <- ordered(Assess$ski_spec_2_btl_corn, levels = c(0, 1), labels = c("no", "yes"))
  Assess$ski_spec_3_btl_corn <- ordered(Assess$ski_spec_3_btl_corn, levels = c(0, 1), labels = c("no", "yes"))
  
  Assess$ski_spec_1_btl_pillows <- ordered(Assess$ski_spec_1_btl_pillows, levels = c(0, 1), labels = c("no", "yes"))
  Assess$ski_spec_2_btl_pillows <- ordered(Assess$ski_spec_2_btl_pillows, levels = c(0, 1), labels = c("no", "yes"))
  Assess$ski_spec_3_btl_pillows <- ordered(Assess$ski_spec_3_btl_pillows, levels = c(0, 1), labels = c("no", "yes"))
  
  Assess$ski_spec_1_btl_fallline <- ordered(Assess$ski_spec_1_btl_fallline, levels = c(0, 1), labels = c("no", "yes"))
  Assess$ski_spec_2_btl_fallline <- ordered(Assess$ski_spec_2_btl_fallline, levels = c(0, 1), labels = c("no", "yes"))
  Assess$ski_spec_3_btl_fallline <- ordered(Assess$ski_spec_3_btl_fallline, levels = c(0, 1), labels = c("no", "yes"))
  
  Assess$ski_spec_1_btl_protect <- ordered(Assess$ski_spec_1_btl_protect, levels = c(0, 1), labels = c("no", "yes"))
  Assess$ski_spec_2_btl_protect <- ordered(Assess$ski_spec_2_btl_protect, levels = c(0, 1), labels = c("no", "yes"))
  Assess$ski_spec_3_btl_protect <- ordered(Assess$ski_spec_3_btl_protect, levels = c(0, 1), labels = c("no", "yes"))
  
  Assess$ski_spec_1_btl_other <- ordered(Assess$ski_spec_1_btl_other, levels = c(0, 1), labels = c("no", "yes"))
  Assess$ski_spec_2_btl_other <- ordered(Assess$ski_spec_2_btl_other, levels = c(0, 1), labels = c("no", "yes"))
  Assess$ski_spec_3_btl_other <- ordered(Assess$ski_spec_3_btl_other, levels = c(0, 1), labels = c("no", "yes"))
  
  Assess$ski_diff_1 <- ordered(Assess$ski_diff_1, levels = c("easy", "mod", "chall"))
  Assess$ski_diff_2 <- ordered(Assess$ski_diff_2, levels = c("easy", "mod", "chall"))
  Assess$ski_diff_3 <- ordered(Assess$ski_diff_3, levels = c("easy", "mod", "chall"))
  
  Assess$ski_chall_1 <- ordered(Assess$ski_chall_1, levels = c("no", "yes"))
  Assess$ski_chall_2 <- ordered(Assess$ski_chall_2, levels = c("no", "yes"))
  Assess$ski_chall_3 <- ordered(Assess$ski_chall_3, levels = c("no", "yes"))
  
  Assess$ski_chall_1_flat <- ordered(Assess$ski_chall_1_flat, levels = c(0, 1), labels = c("no", "yes"))
  Assess$ski_chall_2_flat <- ordered(Assess$ski_chall_2_flat, levels = c(0, 1), labels = c("no", "yes"))
  Assess$ski_chall_3_flat <- ordered(Assess$ski_chall_3_flat, levels = c(0, 1), labels = c("no", "yes"))
  
  Assess$ski_chall_1_entrance <- ordered(Assess$ski_chall_1_entrance, levels = c(0, 1), labels = c("no", "yes"))
  Assess$ski_chall_2_entrance <- ordered(Assess$ski_chall_2_entrance, levels = c(0, 1), labels = c("no", "yes"))
  Assess$ski_chall_3_entrance <- ordered(Assess$ski_chall_3_entrance, levels = c(0, 1), labels = c("no", "yes"))
  
  Assess$ski_chall_1_vegetation <- ordered(Assess$ski_chall_1_vegetation, levels = c(0, 1), labels = c("no", "yes"))
  Assess$ski_chall_2_vegetation <- ordered(Assess$ski_chall_2_vegetation, levels = c(0, 1), labels = c("no", "yes"))
  Assess$ski_chall_3_vegetation <- ordered(Assess$ski_chall_3_vegetation, levels = c(0, 1), labels = c("no", "yes"))
  
  Assess$ski_chall_1_other <- ordered(Assess$ski_chall_1_other, levels = c(0, 1), labels = c("no", "yes"))
  Assess$ski_chall_2_other <- ordered(Assess$ski_chall_2_other, levels = c(0, 1), labels = c("no", "yes"))
  Assess$ski_chall_3_other <- ordered(Assess$ski_chall_3_other, levels = c(0, 1), labels = c("no", "yes"))
  
  Assess$ski_overall_1 <- ordered(Assess$ski_overall_1, levels = c("poor", "fair", "good", "very", "except"))
  Assess$ski_overall_2 <- ordered(Assess$ski_overall_2, levels = c("poor", "fair", "good", "very", "except"))
  Assess$ski_overall_3 <- ordered(Assess$ski_overall_3, levels = c("poor", "fair", "good", "very", "except"))
  
  Assess$use_linetype_1 <- ordered(Assess$use_linetype_1, levels = c("single", "cons", "typ", "agg"))
  Assess$use_linetype_2 <- ordered(Assess$use_linetype_2, levels = c("single", "cons", "typ", "agg")) 
  Assess$use_linetype_3 <- ordered(Assess$use_linetype_3, levels = c("single", "cons", "typ", "agg"))                            
  
  Assess$use_oprole_1 <- ordered(Assess$use_oprole_1, levels = c("no", "yes"))
  Assess$use_oprole_2 <- ordered(Assess$use_oprole_2, levels = c("no", "yes"))
  Assess$use_oprole_3 <- ordered(Assess$use_oprole_3, levels = c("no", "yes"))
  
  Assess$use_oprole_1_safe <- ordered(Assess$use_oprole_1_safe, levels = c(0, 1), labels = c("no", "yes"))
  Assess$use_oprole_2_safe <- ordered(Assess$use_oprole_2_safe, levels = c(0, 1), labels = c("no", "yes"))
  Assess$use_oprole_3_safe <- ordered(Assess$use_oprole_3_safe, levels = c(0, 1), labels = c("no", "yes"))
  
  Assess$use_oprole_1_sign <- ordered(Assess$use_oprole_1_sign, levels = c(0, 1), labels = c("no", "yes"))
  Assess$use_oprole_2_sign <- ordered(Assess$use_oprole_2_sign, levels = c(0, 1), labels = c("no", "yes"))
  Assess$use_oprole_3_sign <- ordered(Assess$use_oprole_3_sign, levels = c(0, 1), labels = c("no", "yes"))
  
  Assess$use_oprole_1_dest <- ordered(Assess$use_oprole_1_dest, levels = c(0, 1), labels = c("no", "yes"))
  Assess$use_oprole_2_dest <- ordered(Assess$use_oprole_2_dest, levels = c(0, 1), labels = c("no", "yes"))
  Assess$use_oprole_3_dest <- ordered(Assess$use_oprole_3_dest, levels = c(0, 1), labels = c("no", "yes"))
  
  Assess$use_oprole_1_bread <- ordered(Assess$use_oprole_1_bread, levels = c(0, 1), labels = c("no", "yes"))
  Assess$use_oprole_2_bread <- ordered(Assess$use_oprole_2_bread, levels = c(0, 1), labels = c("no", "yes"))
  Assess$use_oprole_3_bread <- ordered(Assess$use_oprole_3_bread, levels = c(0, 1), labels = c("no", "yes"))
  
  Assess$use_oprole_1_jump <- ordered(Assess$use_oprole_1_jump, levels = c(0, 1), labels = c("no", "yes"))
  Assess$use_oprole_2_jump <- ordered(Assess$use_oprole_2_jump, levels = c(0, 1), labels = c("no", "yes"))
  Assess$use_oprole_3_jump <- ordered(Assess$use_oprole_3_jump, levels = c(0, 1), labels = c("no", "yes"))
  
  Assess$use_oprole_1_time <- ordered(Assess$use_oprole_1_time, levels = c(0, 1), labels = c("no", "yes"))
  Assess$use_oprole_2_time <- ordered(Assess$use_oprole_2_time, levels = c(0, 1), labels = c("no", "yes"))
  Assess$use_oprole_3_time <- ordered(Assess$use_oprole_3_time, levels = c(0, 1), labels = c("no", "yes"))
  
  Assess$use_oprole_1_lunch <- ordered(Assess$use_oprole_1_lunch, levels = c(0, 1), labels = c("no", "yes"))
  Assess$use_oprole_2_lunch <- ordered(Assess$use_oprole_2_lunch, levels = c(0, 1), labels = c("no", "yes"))
  Assess$use_oprole_3_lunch <- ordered(Assess$use_oprole_3_lunch, levels = c(0, 1), labels = c("no", "yes"))
  
  Assess$use_oprole_1_notpref <- ordered(Assess$use_oprole_1_notpref, levels = c(0, 1), labels = c("no", "yes"))
  Assess$use_oprole_2_notpref <- ordered(Assess$use_oprole_2_notpref, levels = c(0, 1), labels = c("no", "yes"))
  Assess$use_oprole_3_notpref <- ordered(Assess$use_oprole_3_notpref, levels = c(0, 1), labels = c("no", "yes"))
  
  Assess$use_oprole_1_openseason <- ordered(Assess$use_oprole_1_openseason, levels = c(0, 1), labels = c("no", "yes"))
  Assess$use_oprole_2_openseason <- ordered(Assess$use_oprole_2_openseason, levels = c(0, 1), labels = c("no", "yes"))
  Assess$use_oprole_3_openseason <- ordered(Assess$use_oprole_3_openseason, levels = c(0, 1), labels = c("no", "yes"))
  
  Assess$use_oprole_1_rarely <- ordered(Assess$use_oprole_1_rarely, levels = c(0, 1), labels = c("no", "yes"))
  Assess$use_oprole_2_rarely <- ordered(Assess$use_oprole_2_rarely, levels = c(0, 1), labels = c("no", "yes"))
  Assess$use_oprole_3_rarely <- ordered(Assess$use_oprole_3_rarely, levels = c(0, 1), labels = c("no", "yes"))
  
  Assess$use_oprole_1_wx <- ordered(Assess$use_oprole_1_wx, levels = c(0, 1), labels = c("no", "yes"))
  Assess$use_oprole_2_wx <- ordered(Assess$use_oprole_2_wx, levels = c(0, 1), labels = c("no", "yes"))
  Assess$use_oprole_3_wx <- ordered(Assess$use_oprole_3_wx, levels = c(0, 1), labels = c("no", "yes"))
  
  Assess$use_oprole_1_other <- ordered(Assess$use_oprole_1_other, levels = c(0, 1), labels = c("no", "yes"))
  Assess$use_oprole_2_other <- ordered(Assess$use_oprole_2_other, levels = c(0, 1), labels = c("no", "yes"))
  Assess$use_oprole_3_other <- ordered(Assess$use_oprole_3_other, levels = c(0, 1), labels = c("no", "yes"))
  
  Assess$use_suncrust_1 <- ordered(Assess$use_suncrust_1, levels = c("no", "half", "one", "twothree", "more"))
  Assess$use_suncrust_2 <- ordered(Assess$use_suncrust_2, levels = c("no", "half", "one", "twothree", "more"))
  Assess$use_suncrust_3 <- ordered(Assess$use_suncrust_3, levels = c("no", "half", "one", "twothree", "more"))
  
  Assess$use_conflict_run <- ordered(Assess$use_conflict, levels = c("no", "occas", "one", "few", "week"))
  Assess <- deleteDFColumnsByName(Assess, c("use_conflict"))
  Assess$use_conflict_1 <- ordered(Assess$use_conflict_1, levels = c("no", "occas", "one", "few", "week"))
  Assess$use_conflict_2 <- ordered(Assess$use_conflict_2, levels = c("no", "occas", "one", "few", "week"))
  Assess$use_conflict_3 <- ordered(Assess$use_conflict_3, levels = c("no", "occas", "one", "few", "week"))
  
  Assess$use_conflict_run_sm <- ordered(Assess$use_conflict_sm, levels = c(0, 1), labels = c("no", "yes"))
  Assess <- deleteDFColumnsByName(Assess, c("use_conflict_sm"))
  Assess$use_conflict_1_sm <- ordered(Assess$use_conflict_1_sm, levels = c(0, 1), labels = c("no", "yes"))
  Assess$use_conflict_2_sm <- ordered(Assess$use_conflict_2_sm, levels = c(0, 1), labels = c("no", "yes"))
  Assess$use_conflict_3_sm <- ordered(Assess$use_conflict_3_sm, levels = c(0, 1), labels = c("no", "yes"))
  
  Assess$use_conflict_run_smaccess <- ordered(Assess$use_conflict_smaccess, levels = c(0, 1), labels = c("no", "yes"))
  Assess <- deleteDFColumnsByName(Assess, c("use_conflict_smaccess"))
  Assess$use_conflict_1_smaccess <- ordered(Assess$use_conflict_1_smaccess, levels = c(0, 1), labels = c("no", "yes"))
  Assess$use_conflict_2_smaccess <- ordered(Assess$use_conflict_2_smaccess, levels = c(0, 1), labels = c("no", "yes"))
  Assess$use_conflict_3_smaccess <- ordered(Assess$use_conflict_3_smaccess, levels = c(0, 1), labels = c("no", "yes"))
  
  Assess$use_conflict_run_bc <- ordered(Assess$use_conflict_bc, levels = c(0, 1), labels = c("no", "yes"))
  Assess <- deleteDFColumnsByName(Assess, c("use_conflict_bc"))
  Assess$use_conflict_1_bc <- ordered(Assess$use_conflict_1_bc, levels = c(0, 1), labels = c("no", "yes"))
  Assess$use_conflict_2_bc <- ordered(Assess$use_conflict_2_bc, levels = c(0, 1), labels = c("no", "yes"))
  Assess$use_conflict_3_bc <- ordered(Assess$use_conflict_3_bc, levels = c(0, 1), labels = c("no", "yes"))
  
  Assess$use_conflict_run_other <- ordered(Assess$use_conflict_other, levels = c(0, 1), labels = c("no", "yes"))
  Assess$use_conflict_run_othertext <- Assess$use_conflict_othertext
  Assess <- deleteDFColumnsByName(Assess, c("use_conflict_other", "use_conflict_othertext"))
  
  Assess$use_conflict_1_other <- ordered(Assess$use_conflict_1_other, levels = c(0, 1), labels = c("no", "yes"))
  Assess$use_conflict_2_other <- ordered(Assess$use_conflict_2_other, levels = c(0, 1), labels = c("no", "yes"))
  Assess$use_conflict_3_other <- ordered(Assess$use_conflict_3_other, levels = c(0, 1), labels = c("no", "yes"))
  
  Assess$use_wildlife_run <- ordered(Assess$use_wildlife, levels = c("no", "yes"))
  Assess <- deleteDFColumnsByName(Assess, c("use_wildlife"))
  Assess$use_wildlife_1 <- ordered(Assess$use_wildlife_1, levels = c("no", "yes"))
  Assess$use_wildlife_2 <- ordered(Assess$use_wildlife_2, levels = c("no", "yes"))
  Assess$use_wildlife_3 <- ordered(Assess$use_wildlife_3, levels = c("no", "yes"))
  
  Assess$use_wildlife_run_caribou <- ordered(Assess$use_wildlife_caribou, levels = c(0, 1), labels = c("no", "yes"))
  Assess <- deleteDFColumnsByName(Assess, c("use_wildlife_caribou"))
  Assess$use_wildlife_1_caribou <- ordered(Assess$use_wildlife_1_caribou, levels = c(0, 1), labels = c("no", "yes"))
  Assess$use_wildlife_2_caribou <- ordered(Assess$use_wildlife_2_caribou, levels = c(0, 1), labels = c("no", "yes"))
  Assess$use_wildlife_3_caribou <- ordered(Assess$use_wildlife_3_caribou, levels = c(0, 1), labels = c("no", "yes"))
  
  Assess$use_wildlife_run_goat <- ordered(Assess$use_wildlife_goat, levels = c(0, 1), labels = c("no", "yes"))
  Assess <- deleteDFColumnsByName(Assess, c("use_wildlife_goat"))
  Assess$use_wildlife_1_goat <- ordered(Assess$use_wildlife_1_goat, levels = c(0, 1), labels = c("no", "yes"))
  Assess$use_wildlife_2_goat <- ordered(Assess$use_wildlife_2_goat, levels = c(0, 1), labels = c("no", "yes"))
  Assess$use_wildlife_3_goat <- ordered(Assess$use_wildlife_3_goat, levels = c(0, 1), labels = c("no", "yes"))
  
  Assess$use_wildlife_run_wolv <- ordered(Assess$use_wildlife_wolv, levels = c(0, 1), labels = c("no", "yes"))
  Assess <- deleteDFColumnsByName(Assess, c("use_wildlife_wolv"))
  Assess$use_wildlife_1_wolv <- ordered(Assess$use_wildlife_1_wolv, levels = c(0, 1), labels = c("no", "yes"))
  Assess$use_wildlife_2_wolv <- ordered(Assess$use_wildlife_2_wolv, levels = c(0, 1), labels = c("no", "yes"))
  Assess$use_wildlife_3_wolv <- ordered(Assess$use_wildlife_3_wolv, levels = c(0, 1), labels = c("no", "yes"))
  
  Assess$use_wildlife_run_other <- ordered(Assess$use_wildlife_other, levels = c(0, 1), labels = c("no", "yes"))
  Assess$use_wildlife_run_othertext <- Assess$use_wildlife_othertext
  Assess <- deleteDFColumnsByName(Assess, c("use_wildlife_other", "use_wildlife_othertext"))
  Assess$use_wildlife_1_other <- ordered(Assess$use_wildlife_1_other, levels = c(0, 1), labels = c("no", "yes"))
  Assess$use_wildlife_2_other <- ordered(Assess$use_wildlife_2_other, levels = c(0, 1), labels = c("no", "yes"))
  Assess$use_wildlife_3_other <- ordered(Assess$use_wildlife_3_other, levels = c(0, 1), labels = c("no", "yes"))
  
  Assess$hzd_steep_1_alp <- ordered(Assess$hzd_steep_1_alp, levels = c("gentle", "mod", "steeppitch", "steepsusta"))
  Assess$hzd_steep_1_tl  <- ordered(Assess$hzd_steep_1_tl,  levels = c("gentle", "mod", "steeppitch", "steepsusta"))
  Assess$hzd_steep_1_btl <- ordered(Assess$hzd_steep_1_btl, levels = c("gentle", "mod", "steeppitch", "steepsusta"))
  
  Assess$hzd_steep_2_alp <- ordered(Assess$hzd_steep_2_alp, levels = c("gentle", "mod", "steeppitch", "steepsusta"))
  Assess$hzd_steep_2_tl  <- ordered(Assess$hzd_steep_2_tl,  levels = c("gentle", "mod", "steeppitch", "steepsusta"))
  Assess$hzd_steep_2_btl <- ordered(Assess$hzd_steep_2_btl, levels = c("gentle", "mod", "steeppitch", "steepsusta"))
  
  Assess$hzd_steep_3_alp <- ordered(Assess$hzd_steep_3_alp, levels = c("gentle", "mod", "steeppitch", "steepsusta"))
  Assess$hzd_steep_3_tl  <- ordered(Assess$hzd_steep_3_tl,  levels = c("gentle", "mod", "steeppitch", "steepsusta"))
  Assess$hzd_steep_3_btl <- ordered(Assess$hzd_steep_3_btl, levels = c("gentle", "mod", "steeppitch", "steepsusta"))
  
  Assess$hzd_expo_1_alp <- ordered(Assess$hzd_expo_1_alp, levels = c("none", "singlesml", "multiplesml", "lrg"))
  Assess$hzd_expo_1_tl  <- ordered(Assess$hzd_expo_1_tl,  levels = c("none", "singlesml", "multiplesml", "lrg"))
  Assess$hzd_expo_1_btl <- ordered(Assess$hzd_expo_1_btl, levels = c("none", "singlesml", "multiplesml", "lrg"))
  
  Assess$hzd_expo_2_alp <- ordered(Assess$hzd_expo_2_alp, levels = c("none", "singlesml", "multiplesml", "lrg"))
  Assess$hzd_expo_2_tl  <- ordered(Assess$hzd_expo_2_tl,  levels = c("none", "singlesml", "multiplesml", "lrg"))
  Assess$hzd_expo_2_btl <- ordered(Assess$hzd_expo_2_btl, levels = c("none", "singlesml", "multiplesml", "lrg"))
  
  Assess$hzd_expo_3_alp <- ordered(Assess$hzd_expo_3_alp, levels = c("none", "singlesml", "multiplesml", "lrg"))
  Assess$hzd_expo_3_tl  <- ordered(Assess$hzd_expo_3_tl,  levels = c("none", "singlesml", "multiplesml", "lrg"))
  Assess$hzd_expo_3_btl <- ordered(Assess$hzd_expo_3_btl, levels = c("none", "singlesml", "multiplesml", "lrg"))
  
  Assess$hzd_terrainhzd_1_alp <- ordered(Assess$hzd_terrainhzd_1_alp, levels = c("no", "yes"))
  Assess$hzd_terrainhzd_1_tl  <- ordered(Assess$hzd_terrainhzd_1_tl,  levels = c("no", "yes"))
  Assess$hzd_terrainhzd_1_btl <- ordered(Assess$hzd_terrainhzd_1_btl, levels = c("no", "yes"))
  
  Assess$hzd_terrainhzd_1_alp_regularoh <- ordered(Assess$hzd_terrainhzd_1_alp_regularoh, levels = c(0, 1), labels = c("no", "yes"))
  Assess$hzd_terrainhzd_1_alp_largeoh <- ordered(Assess$hzd_terrainhzd_1_alp_largeoh, levels = c(0, 1), labels = c("no", "yes"))
  Assess$hzd_terrainhzd_1_alp_triggeroh <- ordered(Assess$hzd_terrainhzd_1_alp_triggeroh, levels = c(0, 1), labels = c("no", "yes"))
  Assess$hzd_terrainhzd_1_alp_unsupport <- ordered(Assess$hzd_terrainhzd_1_alp_unsupport, levels = c(0, 1), labels = c("no", "yes"))
  Assess$hzd_terrainhzd_1_alp_norough <- ordered(Assess$hzd_terrainhzd_1_alp_norough, levels = c(0, 1), labels = c("no", "yes"))
  Assess$hzd_terrainhzd_1_alp_freqperf <- ordered(Assess$hzd_terrainhzd_1_alp_freqperf, levels = c(0, 1), labels = c("no", "yes"))
  Assess$hzd_terrainhzd_1_alp_highcons <- ordered(Assess$hzd_terrainhzd_1_alp_highcons, levels = c(0, 1), labels = c("no", "yes"))
  Assess$hzd_terrainhzd_1_alp_other <- ordered(Assess$hzd_terrainhzd_1_alp_other, levels = c(0, 1), labels = c("no", "yes"))
  
  Assess$hzd_terrainhzd_1_tl_regularoh <- ordered(Assess$hzd_terrainhzd_1_tl_regularoh, levels = c(0, 1), labels = c("no", "yes"))
  Assess$hzd_terrainhzd_1_tl_largeoh <- ordered(Assess$hzd_terrainhzd_1_tl_largeoh, levels = c(0, 1), labels = c("no", "yes"))
  Assess$hzd_terrainhzd_1_tl_triggeroh <- ordered(Assess$hzd_terrainhzd_1_tl_triggeroh, levels = c(0, 1), labels = c("no", "yes"))
  Assess$hzd_terrainhzd_1_tl_unsupport <- ordered(Assess$hzd_terrainhzd_1_tl_unsupport, levels = c(0, 1), labels = c("no", "yes"))
  Assess$hzd_terrainhzd_1_tl_norough <- ordered(Assess$hzd_terrainhzd_1_tl_norough, levels = c(0, 1), labels = c("no", "yes"))
  Assess$hzd_terrainhzd_1_tl_freqperf <- ordered(Assess$hzd_terrainhzd_1_tl_freqperf, levels = c(0, 1), labels = c("no", "yes"))
  Assess$hzd_terrainhzd_1_tl_highcons <- ordered(Assess$hzd_terrainhzd_1_tl_highcons, levels = c(0, 1), labels = c("no", "yes"))
  Assess$hzd_terrainhzd_1_tl_other <- ordered(Assess$hzd_terrainhzd_1_tl_other, levels = c(0, 1), labels = c("no", "yes"))
  
  Assess$hzd_terrainhzd_1_btl_regularoh <- ordered(Assess$hzd_terrainhzd_1_btl_regularoh, levels = c(0, 1), labels = c("no", "yes"))
  Assess$hzd_terrainhzd_1_btl_largeoh <- ordered(Assess$hzd_terrainhzd_1_btl_largeoh, levels = c(0, 1), labels = c("no", "yes"))
  Assess$hzd_terrainhzd_1_btl_triggeroh <- ordered(Assess$hzd_terrainhzd_1_btl_triggeroh, levels = c(0, 1), labels = c("no", "yes"))
  Assess$hzd_terrainhzd_1_btl_unsupport <- ordered(Assess$hzd_terrainhzd_1_btl_unsupport, levels = c(0, 1), labels = c("no", "yes"))
  Assess$hzd_terrainhzd_1_btl_norough <- ordered(Assess$hzd_terrainhzd_1_btl_norough, levels = c(0, 1), labels = c("no", "yes"))
  Assess$hzd_terrainhzd_1_btl_freqperf <- ordered(Assess$hzd_terrainhzd_1_btl_freqperf, levels = c(0, 1), labels = c("no", "yes"))
  Assess$hzd_terrainhzd_1_btl_highcons <- ordered(Assess$hzd_terrainhzd_1_btl_highcons, levels = c(0, 1), labels = c("no", "yes"))
  Assess$hzd_terrainhzd_1_btl_other <- ordered(Assess$hzd_terrainhzd_1_btl_other, levels = c(0, 1), labels = c("no", "yes"))
  
  Assess$hzd_terrainhzd_2_alp <- ordered(Assess$hzd_terrainhzd_2_alp, levels = c("no", "yes"))
  Assess$hzd_terrainhzd_2_tl  <- ordered(Assess$hzd_terrainhzd_2_tl,  levels = c("no", "yes"))
  Assess$hzd_terrainhzd_2_btl <- ordered(Assess$hzd_terrainhzd_2_btl, levels = c("no", "yes"))
  
  Assess$hzd_terrainhzd_2_alp_regularoh <- ordered(Assess$hzd_terrainhzd_2_alp_regularoh, levels = c(0, 1), labels = c("no", "yes"))
  Assess$hzd_terrainhzd_2_alp_largeoh <- ordered(Assess$hzd_terrainhzd_2_alp_largeoh, levels = c(0, 1), labels = c("no", "yes"))
  Assess$hzd_terrainhzd_2_alp_triggeroh <- ordered(Assess$hzd_terrainhzd_2_alp_triggeroh, levels = c(0, 1), labels = c("no", "yes"))
  Assess$hzd_terrainhzd_2_alp_unsupport <- ordered(Assess$hzd_terrainhzd_2_alp_unsupport, levels = c(0, 1), labels = c("no", "yes"))
  Assess$hzd_terrainhzd_2_alp_norough <- ordered(Assess$hzd_terrainhzd_2_alp_norough, levels = c(0, 1), labels = c("no", "yes"))
  Assess$hzd_terrainhzd_2_alp_freqperf <- ordered(Assess$hzd_terrainhzd_2_alp_freqperf, levels = c(0, 1), labels = c("no", "yes"))
  Assess$hzd_terrainhzd_2_alp_highcons <- ordered(Assess$hzd_terrainhzd_2_alp_highcons, levels = c(0, 1), labels = c("no", "yes"))
  Assess$hzd_terrainhzd_2_alp_other <- ordered(Assess$hzd_terrainhzd_2_alp_other, levels = c(0, 1), labels = c("no", "yes"))
  
  Assess$hzd_terrainhzd_2_tl_regularoh <- ordered(Assess$hzd_terrainhzd_2_tl_regularoh, levels = c(0, 1), labels = c("no", "yes"))
  Assess$hzd_terrainhzd_2_tl_largeoh <- ordered(Assess$hzd_terrainhzd_2_tl_largeoh, levels = c(0, 1), labels = c("no", "yes"))
  Assess$hzd_terrainhzd_2_tl_triggeroh <- ordered(Assess$hzd_terrainhzd_2_tl_triggeroh, levels = c(0, 1), labels = c("no", "yes"))
  Assess$hzd_terrainhzd_2_tl_unsupport <- ordered(Assess$hzd_terrainhzd_2_tl_unsupport, levels = c(0, 1), labels = c("no", "yes"))
  Assess$hzd_terrainhzd_2_tl_norough <- ordered(Assess$hzd_terrainhzd_2_tl_norough, levels = c(0, 1), labels = c("no", "yes"))
  Assess$hzd_terrainhzd_2_tl_freqperf <- ordered(Assess$hzd_terrainhzd_2_tl_freqperf, levels = c(0, 1), labels = c("no", "yes"))
  Assess$hzd_terrainhzd_2_tl_highcons <- ordered(Assess$hzd_terrainhzd_2_tl_highcons, levels = c(0, 1), labels = c("no", "yes"))
  Assess$hzd_terrainhzd_2_tl_other <- ordered(Assess$hzd_terrainhzd_2_tl_other, levels = c(0, 1), labels = c("no", "yes"))
  
  Assess$hzd_terrainhzd_2_btl_regularoh <- ordered(Assess$hzd_terrainhzd_2_btl_regularoh, levels = c(0, 1), labels = c("no", "yes"))
  Assess$hzd_terrainhzd_2_btl_largeoh <- ordered(Assess$hzd_terrainhzd_2_btl_largeoh, levels = c(0, 1), labels = c("no", "yes"))
  Assess$hzd_terrainhzd_2_btl_triggeroh <- ordered(Assess$hzd_terrainhzd_2_btl_triggeroh, levels = c(0, 1), labels = c("no", "yes"))
  Assess$hzd_terrainhzd_2_btl_unsupport <- ordered(Assess$hzd_terrainhzd_2_btl_unsupport, levels = c(0, 1), labels = c("no", "yes"))
  Assess$hzd_terrainhzd_2_btl_norough <- ordered(Assess$hzd_terrainhzd_2_btl_norough, levels = c(0, 1), labels = c("no", "yes"))
  Assess$hzd_terrainhzd_2_btl_freqperf <- ordered(Assess$hzd_terrainhzd_2_btl_freqperf, levels = c(0, 1), labels = c("no", "yes"))
  Assess$hzd_terrainhzd_2_btl_highcons <- ordered(Assess$hzd_terrainhzd_2_btl_highcons, levels = c(0, 1), labels = c("no", "yes"))
  Assess$hzd_terrainhzd_2_btl_other <- ordered(Assess$hzd_terrainhzd_2_btl_other, levels = c(0, 1), labels = c("no", "yes"))
  
  Assess$hzd_terrainhzd_3_alp <- ordered(Assess$hzd_terrainhzd_3_alp, levels = c("no", "yes"))
  Assess$hzd_terrainhzd_3_tl  <- ordered(Assess$hzd_terrainhzd_3_tl,  levels = c("no", "yes"))
  Assess$hzd_terrainhzd_3_btl <- ordered(Assess$hzd_terrainhzd_3_btl, levels = c("no", "yes"))
  
  Assess$hzd_terrainhzd_3_alp_regularoh <- ordered(Assess$hzd_terrainhzd_3_alp_regularoh, levels = c(0, 1), labels = c("no", "yes"))
  Assess$hzd_terrainhzd_3_alp_largeoh <- ordered(Assess$hzd_terrainhzd_3_alp_largeoh, levels = c(0, 1), labels = c("no", "yes"))
  Assess$hzd_terrainhzd_3_alp_triggeroh <- ordered(Assess$hzd_terrainhzd_3_alp_triggeroh, levels = c(0, 1), labels = c("no", "yes"))
  Assess$hzd_terrainhzd_3_alp_unsupport <- ordered(Assess$hzd_terrainhzd_3_alp_unsupport, levels = c(0, 1), labels = c("no", "yes"))
  Assess$hzd_terrainhzd_3_alp_norough <- ordered(Assess$hzd_terrainhzd_3_alp_norough, levels = c(0, 1), labels = c("no", "yes"))
  Assess$hzd_terrainhzd_3_alp_freqperf <- ordered(Assess$hzd_terrainhzd_3_alp_freqperf, levels = c(0, 1), labels = c("no", "yes"))
  Assess$hzd_terrainhzd_3_alp_highcons <- ordered(Assess$hzd_terrainhzd_3_alp_highcons, levels = c(0, 1), labels = c("no", "yes"))
  Assess$hzd_terrainhzd_3_alp_other <- ordered(Assess$hzd_terrainhzd_3_alp_other, levels = c(0, 1), labels = c("no", "yes"))
  
  Assess$hzd_terrainhzd_3_tl_regularoh <- ordered(Assess$hzd_terrainhzd_3_tl_regularoh, levels = c(0, 1), labels = c("no", "yes"))
  Assess$hzd_terrainhzd_3_tl_largeoh <- ordered(Assess$hzd_terrainhzd_3_tl_largeoh, levels = c(0, 1), labels = c("no", "yes"))
  Assess$hzd_terrainhzd_3_tl_triggeroh <- ordered(Assess$hzd_terrainhzd_3_tl_triggeroh, levels = c(0, 1), labels = c("no", "yes"))
  Assess$hzd_terrainhzd_3_tl_unsupport <- ordered(Assess$hzd_terrainhzd_3_tl_unsupport, levels = c(0, 1), labels = c("no", "yes"))
  Assess$hzd_terrainhzd_3_tl_norough <- ordered(Assess$hzd_terrainhzd_3_tl_norough, levels = c(0, 1), labels = c("no", "yes"))
  Assess$hzd_terrainhzd_3_tl_freqperf <- ordered(Assess$hzd_terrainhzd_3_tl_freqperf, levels = c(0, 1), labels = c("no", "yes"))
  Assess$hzd_terrainhzd_3_tl_highcons <- ordered(Assess$hzd_terrainhzd_3_tl_highcons, levels = c(0, 1), labels = c("no", "yes"))
  Assess$hzd_terrainhzd_3_tl_other <- ordered(Assess$hzd_terrainhzd_3_tl_other, levels = c(0, 1), labels = c("no", "yes"))
  
  Assess$hzd_terrainhzd_3_btl_regularoh <- ordered(Assess$hzd_terrainhzd_3_btl_regularoh, levels = c(0, 1), labels = c("no", "yes"))
  Assess$hzd_terrainhzd_3_btl_largeoh <- ordered(Assess$hzd_terrainhzd_3_btl_largeoh, levels = c(0, 1), labels = c("no", "yes"))
  Assess$hzd_terrainhzd_3_btl_triggeroh <- ordered(Assess$hzd_terrainhzd_3_btl_triggeroh, levels = c(0, 1), labels = c("no", "yes"))
  Assess$hzd_terrainhzd_3_btl_unsupport <- ordered(Assess$hzd_terrainhzd_3_btl_unsupport, levels = c(0, 1), labels = c("no", "yes"))
  Assess$hzd_terrainhzd_3_btl_norough <- ordered(Assess$hzd_terrainhzd_3_btl_norough, levels = c(0, 1), labels = c("no", "yes"))
  Assess$hzd_terrainhzd_3_btl_freqperf <- ordered(Assess$hzd_terrainhzd_3_btl_freqperf, levels = c(0, 1), labels = c("no", "yes"))
  Assess$hzd_terrainhzd_3_btl_highcons <- ordered(Assess$hzd_terrainhzd_3_btl_highcons, levels = c(0, 1), labels = c("no", "yes"))
  Assess$hzd_terrainhzd_3_btl_other <- ordered(Assess$hzd_terrainhzd_3_btl_other, levels = c(0, 1), labels = c("no", "yes"))
  
  Assess$hzd_snowcond_1_alp <- ordered(Assess$hzd_snowcond_1_alp, levels = c("no", "yes"))
  Assess$hzd_snowcond_1_tl  <- ordered(Assess$hzd_snowcond_1_tl,  levels = c("no", "yes"))
  Assess$hzd_snowcond_1_btl <- ordered(Assess$hzd_snowcond_1_btl, levels = c("no", "yes"))
  
  Assess$hzd_snowcond_1_alp_windsl <- ordered(Assess$hzd_snowcond_1_alp_windsl, levels = c(0, 1), labels = c("no", "yes"))
  Assess$hzd_snowcond_1_alp_thin <- ordered(Assess$hzd_snowcond_1_alp_thin, levels = c(0, 1), labels = c("no", "yes"))
  Assess$hzd_snowcond_1_alp_variable <- ordered(Assess$hzd_snowcond_1_alp_variable, levels = c(0, 1), labels = c("no", "yes"))
  Assess$hzd_snowcond_1_alp_other <- ordered(Assess$hzd_snowcond_1_alp_other, levels = c(0, 1), labels = c("no", "yes"))
  
  Assess$hzd_snowcond_1_tl_windsl <- ordered(Assess$hzd_snowcond_1_tl_windsl, levels = c(0, 1), labels = c("no", "yes"))
  Assess$hzd_snowcond_1_tl_sh <- ordered(Assess$hzd_snowcond_1_tl_sh, levels = c(0, 1), labels = c("no", "yes"))
  Assess$hzd_snowcond_1_tl_thin <- ordered(Assess$hzd_snowcond_1_tl_thin, levels = c(0, 1), labels = c("no", "yes"))
  Assess$hzd_snowcond_1_tl_variable <- ordered(Assess$hzd_snowcond_1_tl_variable, levels = c(0, 1), labels = c("no", "yes"))
  Assess$hzd_snowcond_1_tl_other <- ordered(Assess$hzd_snowcond_1_tl_other, levels = c(0, 1), labels = c("no", "yes"))
  
  Assess$hzd_snowcond_1_btl_sh <- ordered(Assess$hzd_snowcond_1_btl_sh, levels = c(0, 1), labels = c("no", "yes"))
  Assess$hzd_snowcond_1_btl_thin <- ordered(Assess$hzd_snowcond_1_btl_thin, levels = c(0, 1), labels = c("no", "yes"))
  Assess$hzd_snowcond_1_btl_variable <- ordered(Assess$hzd_snowcond_1_btl_variable, levels = c(0, 1), labels = c("no", "yes"))
  Assess$hzd_snowcond_1_btl_other <- ordered(Assess$hzd_snowcond_1_btl_other, levels = c(0, 1), labels = c("no", "yes"))
  
  Assess$hzd_snowcond_2_alp <- ordered(Assess$hzd_snowcond_2_alp, levels = c("no", "yes"))
  Assess$hzd_snowcond_2_tl  <- ordered(Assess$hzd_snowcond_2_tl,  levels = c("no", "yes"))
  Assess$hzd_snowcond_2_btl <- ordered(Assess$hzd_snowcond_2_btl, levels = c("no", "yes"))
  
  Assess$hzd_snowcond_2_alp_windsl <- ordered(Assess$hzd_snowcond_2_alp_windsl, levels = c(0, 1), labels = c("no", "yes"))
  Assess$hzd_snowcond_2_alp_thin <- ordered(Assess$hzd_snowcond_2_alp_thin, levels = c(0, 1), labels = c("no", "yes"))
  Assess$hzd_snowcond_2_alp_variable <- ordered(Assess$hzd_snowcond_2_alp_variable, levels = c(0, 1), labels = c("no", "yes"))
  Assess$hzd_snowcond_2_alp_other <- ordered(Assess$hzd_snowcond_2_alp_other, levels = c(0, 1), labels = c("no", "yes"))
  
  Assess$hzd_snowcond_2_tl_windsl <- ordered(Assess$hzd_snowcond_2_tl_windsl, levels = c(0, 1), labels = c("no", "yes"))
  Assess$hzd_snowcond_2_tl_sh <- ordered(Assess$hzd_snowcond_2_tl_sh, levels = c(0, 1), labels = c("no", "yes"))
  Assess$hzd_snowcond_2_tl_thin <- ordered(Assess$hzd_snowcond_2_tl_thin, levels = c(0, 1), labels = c("no", "yes"))
  Assess$hzd_snowcond_2_tl_variable <- ordered(Assess$hzd_snowcond_2_tl_variable, levels = c(0, 1), labels = c("no", "yes"))
  Assess$hzd_snowcond_2_tl_other <- ordered(Assess$hzd_snowcond_2_tl_other, levels = c(0, 1), labels = c("no", "yes"))
  
  Assess$hzd_snowcond_2_btl_sh <- ordered(Assess$hzd_snowcond_2_btl_sh, levels = c(0, 1), labels = c("no", "yes"))
  Assess$hzd_snowcond_2_btl_thin <- ordered(Assess$hzd_snowcond_2_btl_thin, levels = c(0, 1), labels = c("no", "yes"))
  Assess$hzd_snowcond_2_btl_variable <- ordered(Assess$hzd_snowcond_2_btl_variable, levels = c(0, 1), labels = c("no", "yes"))
  Assess$hzd_snowcond_2_btl_other <- ordered(Assess$hzd_snowcond_2_btl_other, levels = c(0, 1), labels = c("no", "yes"))
  
  Assess$hzd_snowcond_3_alp <- ordered(Assess$hzd_snowcond_3_alp, levels = c("no", "yes"))
  Assess$hzd_snowcond_3_tl  <- ordered(Assess$hzd_snowcond_3_tl,  levels = c("no", "yes"))
  Assess$hzd_snowcond_3_btl <- ordered(Assess$hzd_snowcond_3_btl, levels = c("no", "yes"))
  
  Assess$hzd_snowcond_3_alp_windsl <- ordered(Assess$hzd_snowcond_3_alp_windsl, levels = c(0, 1), labels = c("no", "yes"))
  Assess$hzd_snowcond_3_alp_thin <- ordered(Assess$hzd_snowcond_3_alp_thin, levels = c(0, 1), labels = c("no", "yes"))
  Assess$hzd_snowcond_3_alp_variable <- ordered(Assess$hzd_snowcond_3_alp_variable, levels = c(0, 1), labels = c("no", "yes"))
  Assess$hzd_snowcond_3_alp_other <- ordered(Assess$hzd_snowcond_3_alp_other, levels = c(0, 1), labels = c("no", "yes"))
  
  Assess$hzd_snowcond_3_tl_windsl <- ordered(Assess$hzd_snowcond_3_tl_windsl, levels = c(0, 1), labels = c("no", "yes"))
  Assess$hzd_snowcond_3_tl_sh <- ordered(Assess$hzd_snowcond_3_tl_sh, levels = c(0, 1), labels = c("no", "yes"))
  Assess$hzd_snowcond_3_tl_thin <- ordered(Assess$hzd_snowcond_3_tl_thin, levels = c(0, 1), labels = c("no", "yes"))
  Assess$hzd_snowcond_3_tl_variable <- ordered(Assess$hzd_snowcond_3_tl_variable, levels = c(0, 1), labels = c("no", "yes"))
  Assess$hzd_snowcond_3_tl_other <- ordered(Assess$hzd_snowcond_3_tl_other, levels = c(0, 1), labels = c("no", "yes"))
  
  Assess$hzd_snowcond_3_btl_sh <- ordered(Assess$hzd_snowcond_3_btl_sh, levels = c(0, 1), labels = c("no", "yes"))
  Assess$hzd_snowcond_3_btl_thin <- ordered(Assess$hzd_snowcond_3_btl_thin, levels = c(0, 1), labels = c("no", "yes"))
  Assess$hzd_snowcond_3_btl_variable <- ordered(Assess$hzd_snowcond_3_btl_variable, levels = c(0, 1), labels = c("no", "yes"))
  Assess$hzd_snowcond_3_btl_other <- ordered(Assess$hzd_snowcond_3_btl_other, levels = c(0, 1), labels = c("no", "yes"))
  
  Assess$hzd_otherhzd_1_alp <- ordered(Assess$hzd_otherhzd_1_alp, levels = c("no", "yes"))
  Assess$hzd_otherhzd_1_tl  <- ordered(Assess$hzd_otherhzd_1_tl,  levels = c("no", "yes"))
  Assess$hzd_otherhzd_1_btl <- ordered(Assess$hzd_otherhzd_1_btl, levels = c("no", "yes"))
  
  Assess$hzd_otherhzd_1_alp_isolcrev <- ordered(Assess$hzd_otherhzd_1_alp_isolcrev, levels = c(0, 1), labels = c("no", "yes"))
  Assess$hzd_otherhzd_1_alp_widecrev <- ordered(Assess$hzd_otherhzd_1_alp_widecrev, levels = c(0, 1), labels = c("no", "yes"))
  Assess$hzd_otherhzd_1_alp_cornice <- ordered(Assess$hzd_otherhzd_1_alp_cornice, levels = c(0, 1), labels = c("no", "yes"))
  Assess$hzd_otherhzd_1_alp_other <- ordered(Assess$hzd_otherhzd_1_alp_other, levels = c(0, 1), labels = c("no", "yes"))
  
  Assess$hzd_otherhzd_1_tl_cornice <- ordered(Assess$hzd_otherhzd_1_tl_cornice, levels = c(0, 1), labels = c("no", "yes"))
  Assess$hzd_otherhzd_1_tl_treewell <- ordered(Assess$hzd_otherhzd_1_tl_treewell, levels = c(0, 1), labels = c("no", "yes"))
  Assess$hzd_otherhzd_1_tl_creeks <- ordered(Assess$hzd_otherhzd_1_tl_creeks, levels = c(0, 1), labels = c("no", "yes"))
  Assess$hzd_otherhzd_1_tl_rescue <- ordered(Assess$hzd_otherhzd_1_tl_rescue, levels = c(0, 1), labels = c("no", "yes"))
  Assess$hzd_otherhzd_1_tl_other <- ordered(Assess$hzd_otherhzd_1_tl_other, levels = c(0, 1), labels = c("no", "yes"))
  
  Assess$hzd_otherhzd_1_btl_cornice <- ordered(Assess$hzd_otherhzd_1_btl_cornice, levels = c(0, 1), labels = c("no", "yes"))
  Assess$hzd_otherhzd_1_btl_treewell <- ordered(Assess$hzd_otherhzd_1_btl_treewell, levels = c(0, 1), labels = c("no", "yes"))
  Assess$hzd_otherhzd_1_btl_creeks <- ordered(Assess$hzd_otherhzd_1_btl_creeks, levels = c(0, 1), labels = c("no", "yes"))
  Assess$hzd_otherhzd_1_btl_bombs <- ordered(Assess$hzd_otherhzd_1_btl_bombs, levels = c(0, 1), labels = c("no", "yes"))
  Assess$hzd_otherhzd_1_btl_rescue <- ordered(Assess$hzd_otherhzd_1_btl_rescue, levels = c(0, 1), labels = c("no", "yes"))
  Assess$hzd_otherhzd_1_btl_other <- ordered(Assess$hzd_otherhzd_1_btl_other, levels = c(0, 1), labels = c("no", "yes"))
  
  Assess$hzd_otherhzd_2_alp <- ordered(Assess$hzd_otherhzd_2_alp, levels = c("no", "yes"))
  Assess$hzd_otherhzd_2_tl  <- ordered(Assess$hzd_otherhzd_2_tl,  levels = c("no", "yes"))
  Assess$hzd_otherhzd_2_btl <- ordered(Assess$hzd_otherhzd_2_btl, levels = c("no", "yes"))
  
  Assess$hzd_otherhzd_2_alp_isolcrev <- ordered(Assess$hzd_otherhzd_2_alp_isolcrev, levels = c(0, 1), labels = c("no", "yes"))
  Assess$hzd_otherhzd_2_alp_widecrev <- ordered(Assess$hzd_otherhzd_2_alp_widecrev, levels = c(0, 1), labels = c("no", "yes"))
  Assess$hzd_otherhzd_2_alp_cornice <- ordered(Assess$hzd_otherhzd_2_alp_cornice, levels = c(0, 1), labels = c("no", "yes"))
  Assess$hzd_otherhzd_2_alp_other <- ordered(Assess$hzd_otherhzd_2_alp_other, levels = c(0, 1), labels = c("no", "yes"))
  
  Assess$hzd_otherhzd_2_tl_cornice <- ordered(Assess$hzd_otherhzd_2_tl_cornice, levels = c(0, 1), labels = c("no", "yes"))
  Assess$hzd_otherhzd_2_tl_treewell <- ordered(Assess$hzd_otherhzd_2_tl_treewell, levels = c(0, 1), labels = c("no", "yes"))
  Assess$hzd_otherhzd_2_tl_creeks <- ordered(Assess$hzd_otherhzd_2_tl_creeks, levels = c(0, 1), labels = c("no", "yes"))
  Assess$hzd_otherhzd_2_tl_rescue <- ordered(Assess$hzd_otherhzd_2_tl_rescue, levels = c(0, 1), labels = c("no", "yes"))
  Assess$hzd_otherhzd_2_tl_other <- ordered(Assess$hzd_otherhzd_2_tl_other, levels = c(0, 1), labels = c("no", "yes"))
  
  Assess$hzd_otherhzd_2_btl_cornice <- ordered(Assess$hzd_otherhzd_2_btl_cornice, levels = c(0, 1), labels = c("no", "yes"))
  Assess$hzd_otherhzd_2_btl_treewell <- ordered(Assess$hzd_otherhzd_2_btl_treewell, levels = c(0, 1), labels = c("no", "yes"))
  Assess$hzd_otherhzd_2_btl_creeks <- ordered(Assess$hzd_otherhzd_2_btl_creeks, levels = c(0, 1), labels = c("no", "yes"))
  Assess$hzd_otherhzd_2_btl_bombs <- ordered(Assess$hzd_otherhzd_2_btl_bombs, levels = c(0, 1), labels = c("no", "yes"))
  Assess$hzd_otherhzd_2_btl_rescue <- ordered(Assess$hzd_otherhzd_2_btl_rescue, levels = c(0, 1), labels = c("no", "yes"))
  Assess$hzd_otherhzd_2_btl_other <- ordered(Assess$hzd_otherhzd_2_btl_other, levels = c(0, 1), labels = c("no", "yes"))
  
  Assess$hzd_otherhzd_3_alp <- ordered(Assess$hzd_otherhzd_3_alp, levels = c("no", "yes"))
  Assess$hzd_otherhzd_3_tl  <- ordered(Assess$hzd_otherhzd_3_tl,  levels = c("no", "yes"))
  Assess$hzd_otherhzd_3_btl <- ordered(Assess$hzd_otherhzd_3_btl, levels = c("no", "yes"))
  
  Assess$hzd_otherhzd_3_alp_isolcrev <- ordered(Assess$hzd_otherhzd_3_alp_isolcrev, levels = c(0, 1), labels = c("no", "yes"))
  Assess$hzd_otherhzd_3_alp_widecrev <- ordered(Assess$hzd_otherhzd_3_alp_widecrev, levels = c(0, 1), labels = c("no", "yes"))
  Assess$hzd_otherhzd_3_alp_cornice <- ordered(Assess$hzd_otherhzd_3_alp_cornice, levels = c(0, 1), labels = c("no", "yes"))
  Assess$hzd_otherhzd_3_alp_other <- ordered(Assess$hzd_otherhzd_3_alp_other, levels = c(0, 1), labels = c("no", "yes"))
  
  Assess$hzd_otherhzd_3_tl_cornice <- ordered(Assess$hzd_otherhzd_3_tl_cornice, levels = c(0, 1), labels = c("no", "yes"))
  Assess$hzd_otherhzd_3_tl_treewell <- ordered(Assess$hzd_otherhzd_3_tl_treewell, levels = c(0, 1), labels = c("no", "yes"))
  Assess$hzd_otherhzd_3_tl_creeks <- ordered(Assess$hzd_otherhzd_3_tl_creeks, levels = c(0, 1), labels = c("no", "yes"))
  Assess$hzd_otherhzd_3_tl_rescue <- ordered(Assess$hzd_otherhzd_3_tl_rescue, levels = c(0, 1), labels = c("no", "yes"))
  Assess$hzd_otherhzd_3_tl_other <- ordered(Assess$hzd_otherhzd_3_tl_other, levels = c(0, 1), labels = c("no", "yes"))
  
  Assess$hzd_otherhzd_3_btl_cornice <- ordered(Assess$hzd_otherhzd_3_btl_cornice, levels = c(0, 1), labels = c("no", "yes"))
  Assess$hzd_otherhzd_3_btl_treewell <- ordered(Assess$hzd_otherhzd_3_btl_treewell, levels = c(0, 1), labels = c("no", "yes"))
  Assess$hzd_otherhzd_3_btl_creeks <- ordered(Assess$hzd_otherhzd_3_btl_creeks, levels = c(0, 1), labels = c("no", "yes"))
  Assess$hzd_otherhzd_3_btl_bombs <- ordered(Assess$hzd_otherhzd_3_btl_bombs, levels = c(0, 1), labels = c("no", "yes"))
  Assess$hzd_otherhzd_3_btl_rescue <- ordered(Assess$hzd_otherhzd_3_btl_rescue, levels = c(0, 1), labels = c("no", "yes"))
  Assess$hzd_otherhzd_3_btl_other <- ordered(Assess$hzd_otherhzd_3_btl_other, levels = c(0, 1), labels = c("no", "yes"))
  
  Assess$hzd_friendly_1_alp <- ordered(Assess$hzd_friendly_1_alp, levels = c("vunfriend", "unfriend", "neutral", "friend", "vfriend"))
  Assess$hzd_friendly_1_tl  <- ordered(Assess$hzd_friendly_1_tl,  levels = c("vunfriend", "unfriend", "neutral", "friend", "vfriend"))
  Assess$hzd_friendly_1_btl <- ordered(Assess$hzd_friendly_1_btl, levels = c("vunfriend", "unfriend", "neutral", "friend", "vfriend"))
  
  Assess$hzd_friendly_2_alp <- ordered(Assess$hzd_friendly_2_alp, levels = c("vunfriend", "unfriend", "neutral", "friend", "vfriend"))
  Assess$hzd_friendly_2_tl  <- ordered(Assess$hzd_friendly_2_tl,  levels = c("vunfriend", "unfriend", "neutral", "friend", "vfriend"))
  Assess$hzd_friendly_2_btl <- ordered(Assess$hzd_friendly_2_btl, levels = c("vunfriend", "unfriend", "neutral", "friend", "vfriend"))
  
  Assess$hzd_friendly_3_alp <- ordered(Assess$hzd_friendly_3_alp, levels = c("vunfriend", "unfriend", "neutral", "friend", "vfriend"))
  Assess$hzd_friendly_3_tl  <- ordered(Assess$hzd_friendly_3_tl,  levels = c("vunfriend", "unfriend", "neutral", "friend", "vfriend"))
  Assess$hzd_friendly_3_btl <- ordered(Assess$hzd_friendly_3_btl, levels = c("vunfriend", "unfriend", "neutral", "friend", "vfriend"))
  
  Assess$mitig_guideabil_1 <- ordered(Assess$mitig_guideabil_1, levels = c("vdiff", "diff", "neutral", "easy", "veasy"))
  Assess$mitig_guideabil_2 <- ordered(Assess$mitig_guideabil_2, levels = c("vdiff", "diff", "neutral", "easy", "veasy"))
  Assess$mitig_guideabil_3 <- ordered(Assess$mitig_guideabil_3, levels = c("vdiff", "diff", "neutral", "easy", "veasy"))
  
  Assess$mitig_explo_1_run    <- ordered(Assess$mitig_explo_1_run,    levels = c("never", "occas", "regul"))
  Assess$mitig_explo_1_oh     <- ordered(Assess$mitig_explo_1_oh,     levels = c("never", "occas", "regul"))
  Assess$mitig_explo_1_pickup <- ordered(Assess$mitig_explo_1_pickup, levels = c("never", "occas", "regul"))
  
  Assess$mitig_explo_2_run    <- ordered(Assess$mitig_explo_2_run,    levels = c("never", "occas", "regul"))
  Assess$mitig_explo_2_oh     <- ordered(Assess$mitig_explo_2_oh,     levels = c("never", "occas", "regul"))
  Assess$mitig_explo_2_pickup <- ordered(Assess$mitig_explo_2_pickup, levels = c("never", "occas", "regul"))
  
  Assess$mitig_explo_3_run    <- ordered(Assess$mitig_explo_3_run,    levels = c("never", "occas", "regul"))
  Assess$mitig_explo_3_oh     <- ordered(Assess$mitig_explo_3_oh,     levels = c("never", "occas", "regul"))
  Assess$mitig_explo_3_pickup <- ordered(Assess$mitig_explo_3_pickup, levels = c("never", "occas", "regul"))
  
  Assess$mitig_skiertraf_1 <- ordered(Assess$mitig_skiertraf_1, levels = c("notsuit", "donot", "maintain"))
  Assess$mitig_skiertraf_2 <- ordered(Assess$mitig_skiertraf_2, levels = c("notsuit", "donot", "maintain"))
  Assess$mitig_skiertraf_3 <- ordered(Assess$mitig_skiertraf_3, levels = c("notsuit", "donot", "maintain"))
  
  Assess$mitig_selfstab_1 <- ordered(Assess$mitig_selfstab_1, levels = c("no", "yes"))
  Assess$mitig_selfstab_2 <- ordered(Assess$mitig_selfstab_2, levels = c("no", "yes"))
  Assess$mitig_selfstab_3 <- ordered(Assess$mitig_selfstab_3, levels = c("no", "yes"))
  
  Assess$mitig_incident_1 <- ordered(Assess$mitig_incident_1, levels = c("no", "aware", "personal"))
  Assess$mitig_incident_2 <- ordered(Assess$mitig_incident_2, levels = c("no", "aware", "personal"))
  Assess$mitig_incident_3 <- ordered(Assess$mitig_incident_3, levels = c("no", "aware", "personal"))
  
  ## User Info
  UserInfo$info_gender <- factor(UserInfo$info_gender, levels = c("male", "female", "other"))
  UserInfo$info_certification <- factor(UserInfo$info_certification, levels = c("mtnguide", "skiguidef", "skiguidea", "csga1", "csga2", "csga3", "other"))
  UserInfo$info_oprole <- factor(UserInfo$info_oprole, levels = c("owner", "oper", "opmgr", "lead", "guide", "other"))

  ## Return results
  Output <- list(Assess = Assess,
                 RunSetup = RunSetup,
                 UserInfo = UserInfo)
  
  return(Output)
  
}