#' Gets minimal relevant line for run assessments UUIDS based on ski terrain characterization.
#'
#' Gets minimal relevant line for run assessments UUIDS based on ski terrain characterization.
#' @param Operation Name of operation.
#' @return List of run assessments UUIDS for Cons, Typ and Aggr lines
#' 
#' @examples 
#' require(SarpGPSTools)
#' require(SarpGPSToolsPrivate)
#' 
#' Oper <- "NEH"
#' RunChar <- getRecordsFromUUID(Operation, "runchar", "assessments")
#' 
#' 
#' @export
 
getRunCharMinRelevantSkiLine <- function(Operation){
  
  RunChar <- getRecordsFromUUID(Operation, "runchar", "assessments")
  
  ## USE SKI TERRAIN CHARACTERIZATION
  ## ********************************
  QuestCode <- "ski_terrain"
  QuestDef <- getRecordsFromQuery(Operation, "SELECT * FROM runchar.questions")
  LineLevels <- convertArrayFromSQL(QuestDef[QuestDef$code==QuestCode,]$linelevels,Numeric=F)
  # ElevLevels <- convertArrayFromSQL(QuestDef[QuestDef$code==QuestCode,]$elevlevels,Numeric=F)
  ElevLevels <- c("alp", "tl", "btl")
  
  ## DETERMINE RELEVANT MINIMAL SKI LINE
  ## ***********************************
  # QuestColNames <- getRunCharQuestColNames(QuestCode=QuestCode, Operation=Operation, AssessTblFormatted=F, ElevLevels=ElevLevels)
  QuestColNames_Cons <- getRunCharQuestColNames(QuestCode=QuestCode, Operation=Operation, AssessTblFormatted=F, ElevLevels=ElevLevels, LineLevels="c")
  QuestColNames_Typ  <- getRunCharQuestColNames(QuestCode=QuestCode, Operation=Operation, AssessTblFormatted=F, ElevLevels=ElevLevels, LineLevels="t")
  QuestColNames_Aggr <- getRunCharQuestColNames(QuestCode=QuestCode, Operation=Operation, AssessTblFormatted=F, ElevLevels=ElevLevels, LineLevels="a")
  
  # RunCharCompact <- RunChar[,c("uuid", "loccatskiruns_uuid","loccatskilines_uuid", QuestColNames)]

  
  ## CHECK IF CONSERVATIVE LINE HAS TERRAIN CHARACTERIZATION
  ## *******************************************************
  RunChar_Cons <- RunChar[,c("uuid", "loccatskiruns_uuid","loccatskilines_uuid", QuestColNames_Cons)]
  RunChar_Cons[RunChar_Cons=="{dna}" | RunChar_Cons=="dna"] <- NA
  check <- as.data.frame(rowSums(is.na(RunChar_Cons[,QuestColNames_Cons])))
  row.names(check) <- RunChar[,"uuid"]
  UUIDS_Cons <- row.names(check)[check<3]

  ## CHECK IF TYPICAL LINE HAS TERRAIN CHARACTERIZATION
  ## *******************************************************
  RunChar_Typ <- RunChar[,c("uuid", "loccatskiruns_uuid","loccatskilines_uuid", QuestColNames_Typ)]
  RunChar_Typ[RunChar_Typ=="{dna}" | RunChar_Typ=="dna"] <- NA
  check <- as.data.frame(rowSums(is.na(RunChar_Typ[,QuestColNames_Typ])))
  row.names(check) <- RunChar[,"uuid"]
  UUIDS_Typ <- row.names(check)[check<3]
  UUIDS_Typ <- UUIDS_Typ[!(UUIDS_Typ %in% UUIDS_Cons)]

  ## CHECK IF AGGRESSIVE LINE HAS TERRAIN CHARACTERIZATION
  ## *******************************************************
  RunChar_Aggr <- RunChar[,c("uuid", "loccatskiruns_uuid","loccatskilines_uuid", QuestColNames_Aggr)]
  RunChar_Aggr[RunChar_Aggr=="{dna}"| RunChar_Aggr=="dna"] <- NA
  check <- as.data.frame(rowSums(is.na(RunChar_Aggr[,QuestColNames_Aggr])))
  row.names(check) <- RunChar[,"uuid"]
  UUIDS_Aggr <- row.names(check)[check<3]
  UUIDS_Aggr <- UUIDS_Aggr[!(UUIDS_Aggr %in% UUIDS_Typ) & !(UUIDS_Aggr %in% UUIDS_Cons)]

  
  ## RETURN
  ## ******
  output <- list("Assess_UUIDS_Cons"=UUIDS_Cons, "Assess_UUIDS_Typ"=UUIDS_Typ, "Assess_UUIDS_Aggr"=UUIDS_Aggr)
  return(output)
  
}# end function