#' Construct column names of run characterization table.
#'
#' Construct column names of run characterization table.
#' @param QuestCode Code for question.
#' @param Operation Operation.
#' @param AssessTblFormatted Switch for getting colum names of the formatted table (default=F).
#' @return vector of column names.
#' @export

getRunCharQuestColNames <- function(QuestCode, Operation, AssessTblFormatted=F, LineLevels=c("c", "t", "a"), ElevLevels=c("all", "alp", "tl", "btl")){
  
  ## CHECK IF 'QuestCode' IS DEFINED IN QUESTION DEFINITION TABLE
  QuestDef <- getRecordsFromQuery(Operation, "SELECT * FROM runchar.questions")
  if (!(QuestCode %in% QuestDef$code)){stop("Cannot recognize 'QuestCode' in question definiton table")}
  
  ## FIND COLUMNS IN DATAFRAME BASED ON QUESTION DEFINITION
  # QuestLineLevel <- convertArrayFromSQL(QuestDef[QuestDef$code==QuestCode,]$linelevels, Numeric = F)
  # QuestElevLevel <- convertArrayFromSQL(QuestDef[QuestDef$code==QuestCode,]$elevlevels, Numeric = F)
  QuestLineLevel <- convertArrayFromSQL(QuestDef[QuestDef$code %in% QuestCode,]$linelevels, Numeric = F)
  QuestElevLevel <- convertArrayFromSQL(QuestDef[QuestDef$code %in% QuestCode,]$elevlevels, Numeric = F)
  
  ifelse(!is.na(QuestLineLevel), QuestLineLevel <- QuestLineLevel[QuestLineLevel %in% LineLevels], QuestLineLevel)
  ifelse(!is.na(QuestElevLevel), QuestElevLevel <- QuestElevLevel[QuestElevLevel %in% ElevLevels], QuestElevLevel)
  
  QuestCol <- paste0(QuestCode, ifelse(is.na(QuestLineLevel), "", paste0("_", QuestLineLevel))) 
  
  a<-vector()
  for (i in 1:length(QuestCol)){
    a <- c(a,paste0(QuestCol[i], ifelse(is.na(QuestElevLevel), "", paste0("_", QuestElevLevel))))
  }
  QuestCol <- a 
  
  if (AssessTblFormatted){
    if (QuestDef[QuestDef$code==QuestCode,]$responsetype=="MC"){
      QuestEnum <- getRecordsFromQuery(Operation, paste0("SELECT * FROM runchar.enum_", QuestCode))
      a<-vector()
      for (i in 1:length(QuestCol)){
        a <- c(a,paste0(QuestCol[i], paste0("_", QuestEnum$code)))
      }
      QuestCol <- a 
    }
  }
    
  return(QuestCol)
}