#' Get run list form for an operation
#'
#' Get run list form for an operation.
#' @param Operation Name of Operation. Used for accessing PostgreSQL database.
#' @param DBType Optional variable for specifying which database type the location catalog should be imported. Values can be 'Main' (default) or 'NodeJS
#' @return dataframe with run list form.
#'
#' @examples
#' require(SarpGPSTools)
#' require(SarpGPSToolsPrivate)
#' require(SarpGPSToolsVis)
#'
#' Operation <- "CMHGL"
#'
#' ## get RunList
#' RunListForm <- getRunListForm(Operation)
#'
#' @export

getRunListForm <- function(Operation, DBType="Main", Verbose=F){

  Query <- "SELECT * from runlist.get_runlist_form()"

  RunListForm <- getRecordsFromQuery(Operation, Query, DBType=DBType, Verbose=Verbose)

  return(RunListForm)

}
