#' Gets summary of available data for a given operation and season
#'
#' Gets summary of available data for a given operation and season
#' @param Operation Name of operation.
#' @param Season Year of Season.
#' 
#' @return List of summary dataframes for each observation type.
#' 
#' @examples 
#' require(SarpGPSTools)
#' require(SarpGPSToolsPrivate)
#' 
#' Operation <- "CMHGL"
#' Season <- 2016
#' 
#' getSeasonSummary(Operation, Season)
#' 
#' 
#' @export

getSeasonSummary <- function(Operation, Season) {

  warning("Not completely implemented yet!", immediate. = T)
  
  ## Dates for Queries
  SeasonStart <- as.Date(paste0(Season-1, "/09/01"))
  SeasonEnd   <- as.Date(paste0(Season, "/08/31"))
  
  ## Run Usage
  Query <- paste0("SELECT Count(uuid) as num_records, Min(date) As date_first, Max(date) As date_last ", 
                     "FROM obs.run_usage ",
                     "WHERE date >= '", SeasonStart, "' and date <= '" , SeasonEnd, "'")
  
  RunUsage <- getRecordsFromQuery(Operation, Query)
  
  ## Run Coding
  Query <- paste0("SELECT Count(uuid) as num_records, Min(date) As date_first, Max(date) As date_last ", 
                  "FROM runlist.codes_skiruns_skilines ",
                  "WHERE date >= '", SeasonStart, "' and date <= '" , SeasonEnd, "'")
  
  RunCoding <- getRecordsFromQuery(Operation, Query)
  
  ## Combine to output
  Output <- list(RunCoding=RunCoding,
                 RunUsage=RunUsage)
  
  return(Output)

}