#' Gets size of polygons in a location catalog table in km2
#'
#' Gets size of polygons in a location catalog table in km2 (oparea, skiruns)
#' @param Operation Name of operation for accessing correct database
#' @param DBTbl Name of database table in loccat schema
#' @param byid Switch whether area should be calculated by polygon (i.e., by id) as as total.
#' @return Size of tenure in km2
#' 
#' @examples 
#' require(SarpGPSTools)
#' require(SarpGPSToolsPrivate)
#' 
#' Oper <- "CMHGL"
#' 
#' SizeOpArea <- getSizeLoccatPolygons("CMHGL", "oparea")
#' 
#' SizeEachSkiRun <- getSizeLoccatPolygons("CMHGL", "skiruns")
#' SizeAllSkiRuns <- getSizeLoccatPolygons("CMHGL", "skiruns", byid=F)
#' 
#' @export

getSizeLoccatPolygons <- function(Operation, DBTbl, byid=T) {

  Polygons <- getSpatialObjectsFromUUID(Operation, "loccat", DBTbl, LocalProjection=T)
  
  Sizekm2 <- gArea(Polygons, byid = byid)/1000/1000  

  return(Sizekm2)
}
