#' Provides table with column definition for specified database table.
#'
#' Provides table with column definition for specified database table.
#' @param Operation Name of Operation. Used for accessing PostgreSQL database.
#' @param Schema Name of database schema
#' @param Tbl Name of database table
#' @param DBType Optional parameter to specify which database to get the table structure from. Values can be 'Main' (default) or 'NodeJS'. 
#' @return Dataframe with column definition
#' @export

getTblStructure <- function (Operation, Schema, Tbl, DBType="Main") {

  ## Create query
  Query <- paste0("SELECT * FROM information_schema.columns ",
                  "WHERE table_schema = '", Schema, "' AND table_name   = '", Tbl, "'")

  ## Get column list
  DF <- getRecordsFromQuery(Operation, Query, DBType=DBType)

  return (DF)

}
